/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.scriptus;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;

@Mojo(name="describe", defaultPhase=LifecyclePhase.INITIALIZE)
public class DescribeMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="git-${project.name}-%s")
    private String format;
    @Parameter(defaultValue="describe")
    private String descriptionProperty;
    @Parameter(property="maven.changeSet.scmDirectory", defaultValue="${project.basedir}")
    private File scmDirectory;
    @Parameter(defaultValue="unknown")
    private String failHash;
    @Parameter(defaultValue="false")
    private boolean fail;
    @Parameter(defaultValue="7")
    private int hashLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        String gitHash;
        block12: {
            gitHash = null;
            try {
                Git git = Git.open((File)this.scmDirectory);
                try {
                    ObjectId head = git.getRepository().resolve("HEAD");
                    if (head != null) {
                        ObjectReader reader = git.getRepository().newObjectReader();
                        try {
                            gitHash = reader.abbreviate((AnyObjectId)head, this.hashLength).name();
                            break block12;
                        }
                        finally {
                            reader.release();
                        }
                    }
                    this.getLog().warn((CharSequence)"Warning: Repository has no commits!");
                }
                finally {
                    git.close();
                }
            }
            catch (RepositoryNotFoundException ex) {
                if (this.fail) {
                    throw new MojoExecutionException("Could not find Git repository", (Exception)((Object)ex));
                }
                this.getLog().warn((CharSequence)("Could not find Git repository in " + this.scmDirectory));
            }
            catch (Exception ex) {
                if (this.fail) {
                    throw new MojoExecutionException("Exception reading Git repository", ex);
                }
                this.getLog().warn((CharSequence)("Failed to get HEAD commit hash: " + ex.getClass().getName() + ":" + ex.getMessage()));
            }
        }
        String formatted = String.format(this.format, gitHash == null ? this.failHash : gitHash);
        this.project.getProperties().put(this.descriptionProperty, formatted);
        this.getLog().info((CharSequence)String.format("Set property \"%s\" to \"%s\"", this.descriptionProperty, formatted));
    }
}

