/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.model.Association;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.ConstructProcedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.AssociationName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.name.NameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;

public class AssociationNameImpl
extends NameImpl<PackageName>
implements AssociationName {
    private static final Logger LOGGER = Logger.getLogger(AssociationNameImpl.class.getName());

    public AssociationNameImpl(String packageName) {
        super(packageName);
    }

    public AssociationNameImpl(PackageName parent, String name) {
        super(parent, name);
    }

    public AssociationNameImpl(Association association) {
        super(new PackageNameImpl(association.getContainer()), association.getName());
    }

    public static AssociationName parseQualifiedClassName(String qualifiedName) throws IllegalArgumentException {
        PackageNameImpl pack = null;
        String[] names = qualifiedName.split("[:.]+");
        for (int i = 0; i < names.length - 1; ++i) {
            pack = new PackageNameImpl(pack, names[i]);
        }
        AssociationNameImpl result = names.length > 0 ? new AssociationNameImpl(pack, names[names.length - 1]) : null;
        return result;
    }

    public RefAssociation getMetaAssociation(RefPackage rootPackage) throws JmiException {
        RefAssociation result;
        assert (rootPackage != null) : "Expected a non-null package";
        RefPackage ownerPackage = this.getOwner() == null ? rootPackage : ((PackageName)this.getOwner()).getMetaPackage(rootPackage);
        try {
            result = ownerPackage.refAssociation(this.getName());
        }
        catch (JmiException ex) {
            throw new IllegalArgumentException("Looking up the association " + this + " reached " + PRINT_MODEL_ELEMENT.execute(ownerPackage) + " for which retrieving the nested class '" + this.getName() + "' caused ", ex);
        }
        return result;
    }

    @Override
    public Name<PackageName> constructName(PackageName parent, String name) {
        return new AssociationNameImpl(parent, name);
    }

    @Override
    public ConstructProcedure<RefAssociationLink> constructTransfromation() {
        return this.newForwardLinkProduction();
    }

    public ConstructProcedure<RefAssociationLink> newForwardLinkProduction() {
        return new ConstructProcedure<RefAssociationLink>(){

            public Procedure<RefAssociationLink> construct(RefPackage sourceExtent, RefPackage targetExtent, final Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) throws RuntimeException, IllegalArgumentException {
                final RefAssociation associationClass = AssociationNameImpl.this.getMetaAssociation(targetExtent);
                Association association = (Association)associationClass.refMetaObject();
                Object result = association.isDerived() ? Procedure.EMPTY : new Procedure<RefAssociationLink>(){

                    public void execute(RefAssociationLink link) throws RuntimeException, IllegalArgumentException {
                        RefObject source = (RefObject)objectsMap.get(link.refFirstEnd());
                        RefObject target = (RefObject)objectsMap.get(link.refSecondEnd());
                        if (source != null) {
                            if (target != null) {
                                associationClass.refAddLink(source, target);
                            } else {
                                LOGGER.log(Level.INFO, "{0} mapped to null", NameImpl.PRINT_MODEL_ELEMENT.execute(link.refSecondEnd()));
                            }
                        } else {
                            LOGGER.log(Level.INFO, "{0} mapped to null", NameImpl.PRINT_MODEL_ELEMENT.execute(link.refFirstEnd()));
                        }
                    }
                };
                return result;
            }
        };
    }

    public ConstructProcedure<RefAssociationLink> newBackwardLinkProduction() {
        return new ConstructProcedure<RefAssociationLink>(){

            public Procedure<RefAssociationLink> construct(RefPackage sourceExtent, RefPackage targetExtent, final Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) throws RuntimeException, IllegalArgumentException {
                final RefAssociation associationClass = AssociationNameImpl.this.getMetaAssociation(targetExtent);
                Association association = (Association)associationClass.refMetaObject();
                Object result = association.isDerived() ? Procedure.EMPTY : new Procedure<RefAssociationLink>(){

                    public void execute(RefAssociationLink link) throws RuntimeException, IllegalArgumentException {
                        RefObject source = (RefObject)objectsMap.get(link.refFirstEnd());
                        RefObject target = (RefObject)objectsMap.get(link.refSecondEnd());
                        if (source != null) {
                            if (target != null) {
                                associationClass.refAddLink(target, source);
                            } else {
                                LOGGER.log(Level.INFO, "{0} mapped to null", NameImpl.PRINT_MODEL_ELEMENT.execute(link.refSecondEnd()));
                            }
                        } else {
                            LOGGER.log(Level.INFO, "{0} mapped to null", NameImpl.PRINT_MODEL_ELEMENT.execute(link.refFirstEnd()));
                        }
                    }
                };
                return result;
            }
        };
    }
}

