/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import java.util.Map;
import javax.jmi.model.Classifier;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.ConstructProcedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.ClassName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.name.NameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;

public class ClassNameImpl
extends NameImpl<Name<?>>
implements ClassName {
    public ClassNameImpl(String packageName) {
        super(packageName);
    }

    public ClassNameImpl(PackageName parent, String name) {
        super(parent, name);
    }

    public ClassNameImpl(ClassName parent, String name) {
        super(parent, name);
    }

    ClassNameImpl(Name<?> parent, String name) {
        super(parent, name);
    }

    public ClassNameImpl(Classifier classifier) {
        super(new PackageNameImpl(classifier.getContainer()), classifier.getName());
    }

    public static ClassName parseQualifiedClassName(String qualifiedName) throws IllegalArgumentException {
        PackageNameImpl pack = null;
        String[] names = qualifiedName.split("[:.]+");
        for (int i = 0; i < names.length - 1; ++i) {
            pack = new PackageNameImpl(pack, names[i]);
        }
        ClassNameImpl result = names.length > 0 ? new ClassNameImpl(pack, names[names.length - 1]) : null;
        return result;
    }

    public RefClass getMetaClass(RefPackage rootPackage) throws JmiException {
        RefClass result;
        RefPackage ownerPackage;
        assert (rootPackage != null) : "Expected a non-null package";
        if (this.getOwner() == null) {
            ownerPackage = rootPackage;
        } else if (this.getOwner() instanceof PackageName) {
            ownerPackage = ((PackageName)this.getOwner()).getMetaPackage(rootPackage);
        } else {
            throw new IllegalArgumentException(this + " should be a class name in order to lookup the corresponding *Class instance");
        }
        try {
            result = ownerPackage.refClass(this.getName());
        }
        catch (JmiException ex) {
            throw new IllegalArgumentException("Looking up the class " + this + " reached " + PRINT_MODEL_ELEMENT.execute(ownerPackage) + " for which retrieving the nested class '" + this.getName() + "' caused ", ex);
        }
        return result;
    }

    @Override
    public Name<Name<?>> constructName(Name<?> parent, String name) {
        return new ClassNameImpl(parent, name);
    }

    @Override
    public ConstructProcedure<?> constructTransfromation() {
        return new ConstructProcedure<RefObject>(){

            public Procedure<RefObject> construct(RefPackage sourceExtent, RefPackage targetExtent, final Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) {
                final RefClass targetClass = ClassNameImpl.this.getMetaClass(targetExtent);
                return new Procedure<RefObject>(){

                    public void execute(RefObject original) throws RuntimeException, IllegalArgumentException {
                        RefObject result = targetClass.refCreateInstance(null);
                        objectsMap.put(original, result);
                    }
                };
            }
        };
    }
}

