/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import java.util.List;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.name.EnumValueName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.core.name.NameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;

public class EnumValueNameImpl
extends NameImpl<Name<?>>
implements EnumValueName {
    public EnumValueNameImpl(String name) {
        super(name);
    }

    public EnumValueNameImpl(Name<?> parentName, String name) {
        super(parentName, name);
    }

    public EnumValueNameImpl(RefPackage targetExtent, RefEnum enumValue) {
        this(EnumValueNameImpl.constructEnumClassName(enumValue.refTypeName(), targetExtent), enumValue.toString());
    }

    private static Name<?> constructEnumClassName(List<String> qualifiedName, RefPackage targetExtent) {
        RefPackage namespace = targetExtent;
        NameImpl packageName = null;
        for (int i = 0; i < qualifiedName.size() - 1; ++i) {
            String name = qualifiedName.get(i);
            if (namespace instanceof RefPackage) {
                try {
                    namespace = namespace.refPackage(name);
                    packageName = new PackageNameImpl((PackageName)packageName, name);
                }
                catch (InvalidNameException ex) {
                    namespace = namespace.refClass(name);
                    packageName = new ClassNameImpl((PackageName)packageName, name);
                }
                continue;
            }
            throw new IllegalArgumentException("Resolving " + qualifiedName + " enumeration name, reached " + PRINT_MODEL_ELEMENT.execute(namespace) + " which cannot contain nested " + name);
        }
        ClassNameImpl result = qualifiedName.size() > 0 ? new ClassNameImpl(packageName, qualifiedName.get(qualifiedName.size() - 1)) : null;
        return result;
    }

    @Override
    public Name<Name<?>> constructName(Name<?> parent, String name) {
        return new EnumValueNameImpl(parent, name);
    }

    public RefEnum lookupValue(RefPackage targetExtent) throws JmiException {
        RefEnum result;
        if (this.getOwner() == null || this.getOwner().getOwner() == null) {
            throw new InvalidNameException(this.toString(), "Expected a parent class and package name provided");
        }
        Object enumClassName = this.getOwner();
        Name enumClassNamespace = enumClassName.getOwner();
        PackageName enumClassNamespaceNamespace = (PackageName)enumClassNamespace.getOwner();
        RefPackage enumClassNamespacePackage = enumClassNamespaceNamespace != null ? enumClassNamespaceNamespace.getMetaPackage(targetExtent) : targetExtent;
        try {
            RefPackage enumClassPackage = enumClassNamespacePackage.refPackage(enumClassNamespace.getName());
            result = enumClassPackage.refGetEnum(enumClassName.getName(), this.getName());
        }
        catch (InvalidNameException ex) {
            RefClass enumClassClass = enumClassNamespacePackage.refClass(enumClassNamespace.getName());
            result = enumClassClass.refGetEnum(enumClassName.getName(), this.getName());
        }
        return result;
    }
}

