/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import java.util.Map;
import javax.jmi.model.Association;
import javax.jmi.model.Classifier;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.ConstructProcedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.ClassName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.name.AssociationNameImpl;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.core.name.FieldNameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.util.key.Hash;

public class NameImpl<P extends Name<?>>
implements Name<P> {
    public static final Name<?> NO_MAP_NAME = new NameImpl("$NO_MAP_NAME$");
    protected static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private final P owner;
    private final String name;
    private final int hash;

    protected NameImpl(String name) {
        this(name, null);
    }

    protected NameImpl(P owner, String name) {
        this(name, owner);
    }

    private NameImpl(String name, P owner) {
        assert (name != null) : "Expected non-null name";
        this.name = name;
        this.owner = owner;
        int hash = this.getClass().hashCode();
        if (owner != null) {
            hash = (hash << 2) + owner.hashCode();
        }
        this.hash = hash = (hash << 2) + Hash.hash(name);
    }

    public static ClassName constructQualifiedMetaObjectName(RefObject modelElement) {
        return (ClassName)NameImpl.constructQualifiedElementName((ModelElement)modelElement.refMetaObject());
    }

    public static Name constructQualifiedElementName(ModelElement metaObject) {
        NameImpl result = metaObject instanceof MofPackage ? new PackageNameImpl((PackageNameImpl)NameImpl.constructQualifiedElementName((ModelElement)metaObject.getContainer()), metaObject.getName()) : (metaObject instanceof Feature ? new FieldNameImpl((ClassNameImpl)NameImpl.constructQualifiedElementName((ModelElement)metaObject.getContainer()), metaObject.getName()) : (metaObject instanceof Association ? new AssociationNameImpl((PackageNameImpl)NameImpl.constructQualifiedElementName((ModelElement)metaObject.getContainer()), metaObject.getName()) : (metaObject instanceof Classifier ? new ClassNameImpl((PackageNameImpl)NameImpl.constructQualifiedElementName((ModelElement)metaObject.getContainer()), metaObject.getName()) : null)));
        return result;
    }

    public final boolean isEmpty() {
        boolean result = this.name.isEmpty();
        return result;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj != null && obj.getClass() == this.getClass()) {
            NameImpl other = (NameImpl)obj;
            result = (this.owner == null && other.owner == null || this.owner != null && this.owner.equals(other.owner)) && this.name.equals(other.name);
        }
        return result;
    }

    public String toString() {
        String result = this.owner == null ? this.name : this.owner.toString() + "::" + this.name;
        return result;
    }

    public final P getOwner() {
        return this.owner;
    }

    public final String getName() {
        return this.name;
    }

    public static Name parseQualifiedName(String qualifiedName) {
        String[] names;
        NameImpl<Object> result = null;
        for (String name : names = qualifiedName.split("[:.]+")) {
            result = new NameImpl<Object>(result, name);
        }
        return result;
    }

    public Name<P> constructName(P parent, String name) {
        return new NameImpl<P>(parent, name);
    }

    public final ConstructProcedure<RefAssociationLink> constructNoTransfromation() {
        return new ConstructProcedure<RefAssociationLink>(){

            public Procedure<RefAssociationLink> construct(RefPackage sourceExtent, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) {
                return Procedure.EMPTY;
            }
        };
    }

    public ConstructProcedure<?> constructTransfromation() {
        return new ConstructProcedure<RefAssociationLink>(){

            public Procedure<RefAssociationLink> construct(RefPackage sourceExtent, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) {
                return Procedure.EMPTY;
            }
        };
    }
}

