/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import javax.jmi.model.Namespace;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.name.NameImpl;

public class PackageNameImpl
extends NameImpl<PackageName>
implements PackageName {
    public PackageNameImpl(String packageName) {
        super(packageName);
    }

    public PackageNameImpl(PackageName parentName, String packageName) {
        super(parentName, packageName);
    }

    public PackageNameImpl(Namespace container) {
        super(container.getContainer() == null ? null : new PackageNameImpl(container.getContainer()), container.getName());
    }

    public static PackageName parseQualifiedPackageName(String qualifiedName) throws IllegalArgumentException {
        String[] names;
        PackageNameImpl result = null;
        for (String name : names = qualifiedName.split("[:.]+")) {
            result = new PackageNameImpl(result, name);
        }
        return result;
    }

    public RefPackage getMetaPackage(RefPackage rootPackage) throws JmiException {
        assert (rootPackage != null) : "Expected a non-null package";
        RefPackage result = this.getOwner() == null ? rootPackage : ((PackageName)this.getOwner()).getMetaPackage(rootPackage);
        try {
            result = result.refPackage(this.getName());
        }
        catch (JmiException ex) {
            throw new IllegalArgumentException("Looking up the package " + this + " reached " + PRINT_MODEL_ELEMENT.execute(result) + " for which retrieving the nested package '" + this.getName() + "' caused ", ex);
        }
        return result;
    }

    @Override
    public Name<PackageName> constructName(PackageName parent, String name) {
        return new PackageNameImpl(parent, name);
    }
}

