/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.name;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Operation;
import net.mdatools.modelant.core.api.model.ConstructOperation;
import net.mdatools.modelant.core.api.model.ConstructProcedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.api.name.StructName;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.core.name.NameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;

public class StructNameImpl
extends NameImpl<Name<?>>
implements StructName {
    public StructNameImpl(String packageName) {
        super(packageName);
    }

    public StructNameImpl(Name<?> parent, String name) {
        super(parent, name);
    }

    public StructNameImpl(RefPackage extent, RefStruct struct) {
        this(StructNameImpl.constructOwnerClassName(struct.refTypeName(), extent), StructNameImpl.getStructName(struct));
    }

    private static String getStructName(RefStruct struct) {
        List names = struct.refTypeName();
        String result = (String)names.get(names.size() - 1);
        return result;
    }

    private static Name<?> constructOwnerClassName(List<String> qualifiedName, RefPackage targetExtent) {
        RefPackage namespace = targetExtent;
        NameImpl result = null;
        for (int i = 0; i < qualifiedName.size() - 1; ++i) {
            String name = qualifiedName.get(i);
            if (namespace instanceof RefPackage) {
                try {
                    namespace = namespace.refPackage(name);
                    result = new PackageNameImpl((PackageName)result, name);
                }
                catch (InvalidNameException ex) {
                    namespace = namespace.refClass(name);
                    result = new ClassNameImpl((PackageName)result, name);
                }
                continue;
            }
            throw new IllegalArgumentException("Resolving " + qualifiedName + " struct name, reached " + PRINT_MODEL_ELEMENT.execute(namespace) + " which cannot contain nested " + name);
        }
        return result;
    }

    @Override
    public Name<Name<?>> constructName(Name<?> parent, String name) {
        return new StructNameImpl(parent, name);
    }

    @Override
    public ConstructProcedure<?> constructTransfromation() {
        throw new IllegalStateException("This method should not be called by design");
    }

    private RefStruct construct(RefPackage targetExtent, List<?> fieldValues) throws JmiException {
        RefStruct result;
        if (this.getOwner() == null) {
            throw new InvalidNameException(this.toString(), "Expected a parent class or package name provided");
        }
        Object structClassNamespace = this.getOwner();
        PackageName structClassNamespaceNamespace = (PackageName)structClassNamespace.getOwner();
        RefPackage structClassNamespacePackage = structClassNamespaceNamespace != null ? structClassNamespaceNamespace.getMetaPackage(targetExtent) : targetExtent;
        try {
            RefPackage structClassPackage = structClassNamespacePackage.refPackage(structClassNamespace.getName());
            result = structClassPackage.refCreateStruct(this.getName(), fieldValues);
        }
        catch (InvalidNameException ex) {
            RefClass structClassClass = structClassNamespacePackage.refClass(structClassNamespace.getName());
            result = structClassClass.refCreateStruct(this.getName(), fieldValues);
        }
        return result;
    }

    public ConstructOperation<RefStruct> constructCopyOperation() {
        return new ConstructOperation<RefStruct>(){

            public Operation<RefStruct> construct(final RefPackage targetExtent, Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) {
                return new Operation<RefStruct>(){

                    public RefStruct execute(RefStruct struct) throws RuntimeException, IllegalArgumentException {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String name : struct.refFieldNames()) {
                            values.add(struct.refGetValue(name));
                        }
                        return StructNameImpl.this.construct(targetExtent, values);
                    }
                };
            }
        };
    }
}

