/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.element;

import java.util.Arrays;
import java.util.List;
import javax.jmi.reflect.RefFeatured;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.util.Navigator;

public abstract class NavigateObjectPath<R>
implements Function<RefFeatured, R> {
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private String[] parsedPath;

    protected NavigateObjectPath(String path) {
        assert (path != null) : "Expected a non-null path provided";
        this.parsedPath = path.split("\\.");
    }

    protected NavigateObjectPath(String[] path) {
        assert (path != null) : "Expected a non-null path provided";
        this.parsedPath = path;
    }

    public final R execute(RefFeatured start) throws RuntimeException, IllegalArgumentException {
        R result;
        if (start == null) {
            throw new IllegalArgumentException("Expected non-null object to start navigating from down the path " + Arrays.asList(this.parsedPath));
        }
        if (this.parsedPath.length == 0) {
            result = this.processEmptyPath(start);
        } else {
            result = null;
            Object current = start;
            for (int i = 0; i < this.parsedPath.length; ++i) {
                Object associated;
                String itemName = this.parsedPath[i];
                try {
                    associated = Navigator.getReflectiveValue(current, itemName);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Starting from " + PRINT_MODEL_ELEMENT.execute(start) + " down the path: " + this.pathUpTo(i) + " reached " + PRINT_MODEL_ELEMENT.execute(current) + " reading '" + itemName + "' on which caused ", ex);
                }
                if (i < this.parsedPath.length - 1) {
                    if (!(associated instanceof RefFeatured)) {
                        throw new IllegalArgumentException("Starting from " + PRINT_MODEL_ELEMENT.execute(start) + " down the path: " + this.pathUpTo(i) + " reached " + PRINT_MODEL_ELEMENT.execute(current) + " for which accessing '" + itemName + "' produced " + PRINT_MODEL_ELEMENT.execute(associated) + " instead of the expected RefFEatured instance");
                    }
                    current = associated;
                    continue;
                }
                try {
                    if (associated instanceof RefFeatured) {
                        result = this.processLast(start, (RefFeatured)current, itemName, (RefFeatured)associated);
                        continue;
                    }
                    result = this.processLast(start, (RefFeatured)current, itemName, associated);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Starting from " + PRINT_MODEL_ELEMENT.execute(start) + " down the path: " + this.pathUpTo(i) + " reached " + PRINT_MODEL_ELEMENT.execute(current) + " for which processing '" + itemName + "' caused ", ex);
                }
            }
        }
        return result;
    }

    private List<String> pathUpTo(int i) {
        return Arrays.asList(Arrays.copyOf(this.parsedPath, i));
    }

    protected abstract R processEmptyPath(RefFeatured var1);

    protected abstract R processLast(RefFeatured var1, RefFeatured var2, String var3, RefFeatured var4);

    protected abstract R processLast(RefFeatured var1, RefFeatured var2, String var3, Object var4);
}

