/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.element;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.util.Navigator;

public class PrintElementRestricted
implements Function<Object, String> {
    private static Logger LOGGER = Logger.getLogger(PrintElementRestricted.class.getPackage().getName());
    private final MatchingCriteria criteria;
    private final String prefix;

    public PrintElementRestricted(String prefix, MatchingCriteria criteria) {
        this.criteria = criteria;
        this.prefix = prefix == null ? "" : prefix;
    }

    public String execute(Object argument) throws RuntimeException, IllegalArgumentException {
        StringBuilder result = new StringBuilder(2048);
        this.append(result, argument, this.prefix);
        return result.toString();
    }

    private void append(StringBuilder result, Object object, String prefix) {
        if (object instanceof RefFeatured) {
            this.append(result, (RefBaseObject)object, prefix);
        } else if (object instanceof Collection) {
            this.append(result, (Collection)object, prefix);
        } else {
            result.append(object);
        }
    }

    private void append(StringBuilder result, RefBaseObject forObject, String prefix) {
        block7: {
            String nested2Prefix;
            String nestedPrefix;
            List asociationNames;
            List attributeNames;
            block8: {
                List<? extends Object> associated;
                String name;
                block9: {
                    List<? extends Object> values;
                    result.append(((GeneralizableElement)forObject.refMetaObject()).getName());
                    if (!(forObject instanceof RefObject)) break block7;
                    attributeNames = this.criteria.getAttributes((RefObject)forObject);
                    asociationNames = this.criteria.getAssociations((RefObject)forObject);
                    if (attributeNames.size() + asociationNames.size() == 0) break block7;
                    nestedPrefix = prefix + "  ";
                    nested2Prefix = nestedPrefix + "  ";
                    if (attributeNames.size() + asociationNames.size() != 1 && (attributeNames.size() != 1 || asociationNames.size() != 1)) break block8;
                    if (attributeNames.size() == 1 && (values = Navigator.collectValues((RefFeatured)((RefObject)forObject), (String)attributeNames.get(0), LOGGER.isLoggable(Level.FINE))).size() > 0) {
                        this.append(result, values, nestedPrefix);
                    }
                    if (asociationNames.size() != 1) break block7;
                    name = (String)asociationNames.get(0);
                    associated = Navigator.collectValues((RefFeatured)((RefObject)forObject), name, false);
                    if (associated.size() != 1) break block9;
                    result.append("/");
                    this.append(result, (RefBaseObject)((RefObject)associated.get(0)), prefix);
                    break block7;
                }
                if (associated.size() <= 1) break block7;
                this.appendAssociated(result, name, associated, nestedPrefix, nested2Prefix);
                break block7;
            }
            for (String name : attributeNames) {
                try {
                    List<? extends Object> values = Navigator.collectValues((RefFeatured)((RefObject)forObject), name, false);
                    if (values.size() <= 0) continue;
                    result.append("\n").append(nestedPrefix).append(name).append("=");
                    this.append(result, values, prefix);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Model element: {0} does not support attribute: {1}", new Object[]{new PrintModelElement(nestedPrefix).execute(forObject), name});
                }
            }
            for (String name : asociationNames) {
                try {
                    List<? extends Object> associated = Navigator.collectValues((RefFeatured)((RefObject)forObject), name, false);
                    this.appendAssociated(result, name, associated, nestedPrefix, nested2Prefix);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Accessing associated {1} on model element {0} caused {2}", new Object[]{new PrintModelElement(nestedPrefix).execute(forObject), name, ex.getMessage()});
                }
            }
        }
    }

    private void appendAssociated(StringBuilder result, String name, List associated, String nestedPrefix, String nested2Prefix) {
        if (associated.size() > 0) {
            result.append("\n").append(nestedPrefix).append(name).append("=");
            if (associated.size() == 1) {
                this.append(result, (RefBaseObject)((RefObject)associated.get(0)), nestedPrefix);
            } else {
                for (Object node : associated) {
                    result.append("\n").append(nested2Prefix);
                    this.append(result, (RefBaseObject)((RefObject)node), nested2Prefix);
                }
            }
        }
    }

    private void append(StringBuilder result, Collection collection, String prefix) {
        String nested = prefix + "  ";
        result.append(" ");
        Iterator valuesIterator = collection.iterator();
        if (!valuesIterator.hasNext()) {
            result.append("{}");
        } else {
            Object value = valuesIterator.next();
            boolean onSeparateLine = this.shouldPrintOnSeparateLine(value);
            if (!valuesIterator.hasNext()) {
                this.appendSingleValue(result, value, onSeparateLine, nested);
            } else {
                result.append("{");
                this.appendSingleValue(result, value, onSeparateLine, nested);
                while (valuesIterator.hasNext()) {
                    value = valuesIterator.next();
                    result.append(", ");
                    this.appendSingleValue(result, value, onSeparateLine |= this.shouldPrintOnSeparateLine(value), nested);
                }
                if (onSeparateLine) {
                    result.append("\n").append(prefix).append(" ");
                }
                result.append("}");
            }
        }
    }

    private boolean shouldPrintOnSeparateLine(Object value) {
        return value instanceof RefBaseObject || value instanceof RefStruct || value instanceof RefEnum || value instanceof RefAssociation || value instanceof RefAssociationLink;
    }

    private void appendSingleValue(StringBuilder result, Object value, boolean isModelElement, String nested) {
        if (isModelElement) {
            result.append("\n").append(nested);
            this.append(result, value, nested);
        } else {
            this.append(result, value, nested);
        }
    }
}

