/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.model.Attribute;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Function;

public class PrintModelElement
implements Function<Object, String> {
    private final String prefix;

    public PrintModelElement() {
        this("");
    }

    public PrintModelElement(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    public String execute(Object object) throws RuntimeException, IllegalArgumentException {
        StringBuilder result = new StringBuilder(2048);
        this.toString(object, result, this.prefix, new HashSet());
        return result.toString();
    }

    private void toString(Object wrapped, StringBuilder result, String prefix, Set visited) {
        if (!visited.contains(wrapped)) {
            if (wrapped instanceof JmiException) {
                this.append(result, prefix, (JmiException)((Object)wrapped), visited);
            } else if (wrapped instanceof RefClass) {
                visited.add(wrapped);
                this.append(result, (RefClass)wrapped, visited);
            } else if (wrapped instanceof RefPackage) {
                visited.add(wrapped);
                this.append(result, (RefPackage)wrapped, visited);
            } else if (wrapped instanceof RefAssociation) {
                visited.add(wrapped);
                this.append(result, prefix, (RefAssociation)wrapped, visited);
            } else if (wrapped instanceof RefFeatured) {
                visited.add(wrapped);
                this.append(result, prefix, (RefFeatured)wrapped, visited);
            } else if (wrapped instanceof RefStruct) {
                visited.add(wrapped);
                this.append(result, prefix, (RefStruct)wrapped, visited);
            } else if (wrapped instanceof RefAssociationLink) {
                visited.add(wrapped);
                this.append(result, prefix, (RefAssociationLink)wrapped, visited);
            } else if (wrapped instanceof RefEnum) {
                visited.add(wrapped);
                this.append(result, (RefEnum)wrapped, visited);
            } else if (wrapped instanceof Collection) {
                this.append(result, prefix, (Collection)wrapped, visited);
            } else {
                result.append(wrapped);
            }
        } else {
            result.append("<visited>");
        }
    }

    private void append(StringBuilder result, String prefix, JmiException exception, Set visited) {
        result.append(((Object)((Object)exception)).getClass());
        result.append(" {\n");
        result.append(prefix);
        result.append("  message = ");
        result.append(exception.getMessage());
        result.append("\n");
        result.append(prefix);
        result.append("  elementInError = ");
        this.toString(exception.getElementInError(), result, prefix + "  ", visited);
        result.append("\n");
        result.append(prefix);
        result.append("  objectInError = ");
        this.toString(exception.getObjectInError(), result, prefix + "  ", visited);
        result.append("\n");
        result.append(prefix);
        result.append("}");
    }

    private void append(StringBuilder result, String prefix, RefFeatured object, Set visited) {
        MofClass metaObject2 = (MofClass)object.refMetaObject();
        String prefixNested = prefix + "  ";
        result.append(metaObject2.getName()).append(" {\n");
        ArrayList<MofClass> allMetaObjects = new ArrayList<MofClass>();
        allMetaObjects.add(metaObject2);
        allMetaObjects.addAll(metaObject2.allSupertypes());
        for (MofClass metaObject2 : allMetaObjects) {
            for (ModelElement contents : metaObject2.getContents()) {
                if (!(contents instanceof Attribute)) continue;
                result.append(prefixNested).append(contents.getName());
                try {
                    Object value = object.refGetValue((RefObject)contents);
                    result.append("=");
                    this.toString(value, result, prefixNested, visited);
                }
                catch (Exception e) {
                    result.append(" exception caused: " + e.getClass().getName() + " : " + e.getMessage());
                }
                result.append(",\n");
            }
        }
        result.append(prefix).append("}");
    }

    private void append(StringBuilder result, String prefix, RefStruct object, Set visited) {
        String prefixNested = prefix + "  ";
        List typeNames = object.refTypeName();
        result.append(typeNames.get(typeNames.size() - 1)).append(" {\n");
        for (String name : object.refFieldNames()) {
            result.append(prefixNested).append(name);
            try {
                Object value = object.refGetValue(name);
                result.append("=");
                this.toString(value, result, prefixNested, visited);
            }
            catch (Exception e) {
                result.append(" exception caused: " + e.getClass().getName() + " : " + e.getMessage());
            }
            result.append(",\n");
        }
        result.append(prefix).append("}");
    }

    private void append(StringBuilder result, RefPackage object, Set visited) {
        result.append("RefPackage ").append(object.refMetaObject().refGetValue("name"));
    }

    private void append(StringBuilder result, RefEnum object, Set visited) {
        result.append("RefEnum ").append(object.refTypeName()).append(" ").append(object.toString());
    }

    private void append(StringBuilder result, RefClass object, Set visited) {
        result.append("RefClass ").append(object.refMetaObject().refGetValue("name"));
    }

    private void append(StringBuilder result, String prefix, RefAssociation object, Set visited) {
        result.append("RefAssociation ").append(object.refMetaObject().refGetValue("name"));
        result.append(" {\n");
        result.append(prefix).append("}");
    }

    private void append(StringBuilder result, String prefix, RefAssociationLink object, Set visited) {
        result.append("RefAssociationLink ").append("{\n").append(prefix).append("  firstEnd=");
        this.toString(object.refFirstEnd(), result, prefix + "  ", visited);
        result.append("\n").append(prefix).append("  secondEnd=");
        this.toString(object.refSecondEnd(), result, prefix + "  ", visited);
        result.append("\n").append(prefix).append("}");
    }

    private void append(StringBuilder result, String prefix, Collection collection, Set visited) {
        result.append("{");
        boolean onSeparateLine = false;
        Iterator valuesIterator = collection.iterator();
        while (valuesIterator.hasNext()) {
            Object value = valuesIterator.next();
            if (onSeparateLine |= value instanceof RefBaseObject || value instanceof RefStruct || value instanceof RefEnum || value instanceof RefAssociation || value instanceof RefAssociationLink) {
                result.append("\n");
                result.append(prefix + "  ");
            }
            this.toString(value, result, prefix + "  ", visited);
            if (!valuesIterator.hasNext()) continue;
            result.append(",");
        }
        if (onSeparateLine) {
            result.append("\n").append(prefix).append("}");
        } else {
            result.append("}");
        }
    }

    public Object toPrint(Object wrapped) {
        return new ToString(wrapped);
    }

    private class ToString {
        private final Object wrapped;

        public ToString(Object wrapped) {
            this.wrapped = wrapped;
        }

        public String toString() {
            return PrintModelElement.this.execute(this.wrapped);
        }
    }
}

