/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.format;

import net.mdatools.modelant.core.api.Operation;
import net.mdatools.modelant.core.util.NameTokenizer;

public abstract class FormatWordsString
implements Operation<String> {
    private final String separator;

    protected FormatWordsString(String separator) {
        if (separator == null) {
            throw new IllegalArgumentException("Expected a non-null separator string");
        }
        this.separator = separator;
    }

    public final String execute(String source) throws RuntimeException, IllegalArgumentException {
        assert (source != null) : "Expected a non-null source";
        StringBuilder result = new StringBuilder(source.length());
        source = this.prepare(source);
        NameTokenizer wordIterator = new NameTokenizer(source);
        while (wordIterator.hasNext()) {
            String word = (String)wordIterator.next();
            if (result.length() == 0) {
                this.formatFirstWord(result, word, wordIterator.hasNext());
                continue;
            }
            result.append(this.separator);
            this.formatNextWord(result, word, wordIterator.hasNext());
        }
        return result.toString();
    }

    protected abstract String prepare(String var1);

    protected abstract void formatFirstWord(StringBuilder var1, String var2, boolean var3);

    protected abstract void formatNextWord(StringBuilder var1, String var2, boolean var3);

    protected final void formatFirstCapitalAllLower(StringBuilder result, String name) {
        if (name.length() > 0) {
            result.append(Character.toUpperCase(name.charAt(0)));
            result.append(name.substring(1).toLowerCase());
        }
    }
}

