/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.format;

import java.util.StringTokenizer;
import net.mdatools.modelant.core.api.Function;

public class FormatWrapText
implements Function<String, String> {
    private static final String SEPARATOR_TAB = "\t";
    private static final String SEPARATOR_SPACE = " ";
    private static final String SEPARATORS = " \t";
    private final String lineSeparator;
    private final int maxLineLength;
    private final String prefix;
    private final String defaultVal;

    public FormatWrapText() {
        this("", "");
    }

    public FormatWrapText(String prefix, String defaultVal) {
        this(prefix, defaultVal, 105);
    }

    public FormatWrapText(String prefix, String defaultVal, int maxLineLength) {
        this(prefix, defaultVal, maxLineLength, System.getProperty("line.separator"));
    }

    public FormatWrapText(String prefix, String defaultVal, int maxLineLength, String lineSeparator) {
        assert (prefix != null) : "Expected a non-null prefix provided";
        assert (defaultVal != null) : "Expected a non-null default value provided";
        assert (lineSeparator != null) : "Expected a non-null line separator provided";
        assert (maxLineLength > 0) : "Expected a positive line length";
        this.prefix = prefix;
        this.defaultVal = defaultVal;
        this.maxLineLength = maxLineLength;
        this.lineSeparator = lineSeparator;
    }

    public final String execute(String line) {
        String result;
        if (line != null && !line.isEmpty()) {
            StringBuilder resultLines = new StringBuilder();
            StringTokenizer paragraphs = new StringTokenizer(line, "\n\r\f");
            while (paragraphs.hasMoreTokens()) {
                String paragraph = paragraphs.nextToken();
                this.wrapParagraph(paragraph, resultLines);
            }
            result = resultLines.toString();
        } else {
            result = this.defaultVal;
        }
        return result;
    }

    private void wrapParagraph(String paragraph, StringBuilder resultLines) {
        int linesize = 0;
        StringTokenizer tokens = new StringTokenizer(paragraph, SEPARATORS, true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (linesize == 0) {
                if (!token.equals(SEPARATOR_SPACE) && !token.equals(SEPARATOR_TAB)) {
                    resultLines.append(this.prefix);
                    linesize += this.prefix.length();
                    resultLines.append(token);
                    linesize += token.length();
                }
            } else {
                resultLines.append(token);
                linesize += token.length();
            }
            if (linesize < this.maxLineLength) continue;
            this.thrimTrailingSeparator(resultLines);
            resultLines.append(this.lineSeparator);
            linesize = 0;
        }
        if (linesize > 0) {
            this.thrimTrailingSeparator(resultLines);
            resultLines.append(this.lineSeparator);
        }
    }

    private void thrimTrailingSeparator(StringBuilder resultLines) {
        while (SEPARATORS.contains("" + resultLines.charAt(resultLines.length() - 1))) {
            resultLines.setLength(resultLines.length() - 1);
        }
    }
}

