/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;

class CachedModelElement {
    private final RefObject wrapped;
    private final Map<String, Object> attributeValues = new HashMap<String, Object>();
    private final Map<String, Object> associationValues = new HashMap<String, Object>();

    private CachedModelElement(RefObject wrapped, Collection<String> attributeNames, Collection<String> associationNames) {
        Object value;
        if (wrapped == null) {
            throw new IllegalArgumentException("Expected a non-null model element to wrap");
        }
        this.wrapped = wrapped;
        for (String attributeName : attributeNames) {
            value = wrapped.refGetValue(attributeName);
            this.attributeValues.put(attributeName, value);
        }
        for (String associationName : associationNames) {
            value = wrapped.refGetValue(associationName);
            if (value instanceof Collection) {
                this.associationValues.put(associationName, new ArrayList((Collection)value));
                continue;
            }
            this.associationValues.put(associationName, value);
        }
    }

    public static Collection<CachedModelElement> cacheModel(Collection<RefObject> elements, Collection<String> attributeNames, Collection<String> associationNames) {
        ArrayList<CachedModelElement> result = new ArrayList<CachedModelElement>();
        for (RefObject element : elements) {
            result.add(new CachedModelElement(element, attributeNames, associationNames));
        }
        return result;
    }

    public final RefObject getWrapped() {
        return this.wrapped;
    }

    public Set<String> getAttributeNames() {
        return this.attributeValues.keySet();
    }

    public Set<String> getAssociationNames() {
        return this.associationValues.keySet();
    }

    public Object getAttributeValue(String name) {
        return this.attributeValues.get(name);
    }

    public Object getAssociationValue(String name) {
        return this.associationValues.get(name);
    }
}

