/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.core.api.diff.InstanceDifference;
import net.mdatools.modelant.core.api.diff.ModelComparisonResult;
import net.mdatools.modelant.core.api.match.ConsideredEqual;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.operation.element.RetrieveAssociations;
import net.mdatools.modelant.core.operation.element.RetrieveAttributes;
import net.mdatools.modelant.core.operation.model.CachedModelElement;
import net.mdatools.modelant.core.operation.model.InstanceDifferencesImpl;
import net.mdatools.modelant.core.operation.model.ModelComparisonResultImpl;
import net.mdatools.modelant.core.operation.model.topology.CacheClassResults;
import net.mdatools.modelant.core.operation.model.topology.EquivalenceClassesMap;
import net.mdatools.modelant.core.operation.model.topology.EquivalenceClassesMapImpl;
import net.mdatools.modelant.core.operation.model.topology.ModelTopology;
import net.mdatools.modelant.core.operation.model.topology.Node;
import net.mdatools.modelant.core.util.Navigator;

public class CompareModels
implements Function<RefPackage, ModelComparisonResult> {
    private static final Logger LOGGER = Logger.getLogger(CompareModels.class.getName());
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private final MatchingCriteria exactMatchCriteria;
    private final MatchingCriteria exceptionMatchCriteria;
    private final List<ConsideredEqual> bindings = new ArrayList<ConsideredEqual>();
    private final RefPackage sourceModelExtent;
    private final Function<RefObject, Collection<String>> retrieveAssociations = new CacheClassResults(new RetrieveAssociations());
    private final Function<RefObject, Collection<String>> retrieveAttributes = new CacheClassResults(new RetrieveAttributes());

    public CompareModels(MatchingCriteria exactMatchCriteria, MatchingCriteria exceptionMatchCriteria, List<ConsideredEqual> bindings, RefPackage sourceModelExtent) {
        if (exactMatchCriteria == null) {
            throw new IllegalArgumentException("Expected non-null exact match criteria provided");
        }
        this.exactMatchCriteria = exactMatchCriteria;
        if (exceptionMatchCriteria == null) {
            throw new IllegalArgumentException("Expected non-null exceptions of the match provided");
        }
        this.exceptionMatchCriteria = exceptionMatchCriteria;
        if (bindings == null) {
            throw new IllegalArgumentException("Expected non-null list of in advance known equal elements");
        }
        this.bindings.addAll(bindings);
        if (sourceModelExtent == null) {
            throw new IllegalArgumentException("Expected non-null extent of the \"old\" model");
        }
        this.sourceModelExtent = sourceModelExtent;
    }

    public ModelComparisonResult execute(RefPackage targetModelExtent) throws IllegalArgumentException {
        List<RefObject> allNewNodes = Navigator.getAllObjects(targetModelExtent);
        List<RefObject> allOldNodes = Navigator.getAllObjects(this.sourceModelExtent);
        ModelTopology newTopology = new ModelTopology();
        newTopology.load(this.exactMatchCriteria, allNewNodes);
        ModelTopology oldTopology = new ModelTopology();
        oldTopology.load(this.exactMatchCriteria, allOldNodes);
        EquivalenceClassesMapImpl<RefObject> equals = new EquivalenceClassesMapImpl<RefObject>();
        this.defineExternallyProvidedEquals(this.sourceModelExtent, targetModelExtent, this.bindings, equals);
        this.excludeEquivalent(oldTopology, newTopology, equals);
        this.findEquals(oldTopology, newTopology, equals);
        ArrayList<InstanceDifference> changes = new ArrayList<InstanceDifference>();
        ArrayList<InstanceDifference> exactMatches = new ArrayList<InstanceDifference>();
        this.detectElementChanges(exactMatches, changes, equals);
        ModelComparisonResultImpl result = new ModelComparisonResultImpl(this.exactMatchCriteria, newTopology.getContents(), oldTopology.getContents(), changes, exactMatches);
        newTopology.clear();
        oldTopology.clear();
        return result;
    }

    private void defineExternallyProvidedEquals(RefPackage sourceRootPackage, RefPackage targetRootPackage, List<ConsideredEqual> consideredEquals, EquivalenceClassesMap<RefObject> equivalenceClasses) {
        for (ConsideredEqual binding : consideredEquals) {
            Collection sourceObjects = (Collection)binding.selectOld().execute((Object)sourceRootPackage);
            Collection targetObjects = (Collection)binding.selectNew().execute((Object)targetRootPackage);
            if (sourceObjects.isEmpty() || targetObjects.isEmpty()) continue;
            equivalenceClasses.add((RefObject)sourceObjects, (RefObject)targetObjects);
        }
    }

    private void excludeEquivalent(ModelTopology sourceTopology, ModelTopology targetTopology, EquivalenceClassesMap<RefObject> equivalenceClasses) {
        for (RefObject representative : equivalenceClasses.getXKeys()) {
            sourceTopology.remove(equivalenceClasses.getEquivalents(representative));
            targetTopology.remove(equivalenceClasses.getEquivalents(equivalenceClasses.map(representative)));
        }
    }

    private void findEquals(ModelTopology sourceTopology, ModelTopology targetTopology, EquivalenceClassesMap<RefObject> equivalenceClasses) {
        ArrayList<Node<RefObject>> unmatchedSources = new ArrayList<Node<RefObject>>();
        ArrayList<Node<RefObject>> collectedMatchedSources = new ArrayList<Node<RefObject>>();
        ArrayList<Node<RefObject>> collectedMatchedTargets = new ArrayList<Node<RefObject>>();
        int iteration = 0;
        ArrayList<Node<Object>> sourceGenerationReady = sourceTopology.getGenerationOfReady();
        ArrayList<Node<RefObject>> targetGenerationReady = targetTopology.getGenerationOfReady();
        while (!sourceGenerationReady.isEmpty()) {
            ++iteration;
            while (!sourceGenerationReady.isEmpty()) {
                Node sourceRepresentative = (Node)sourceGenerationReady.get(0);
                List matchedTargets = Node.findReadyMatches(equivalenceClasses, sourceRepresentative, targetGenerationReady);
                LOGGER.log(Level.FINER, "Matching {0} found at the target side {1}", new Object[]{PRINT_MODEL_ELEMENT.toPrint(sourceRepresentative), PRINT_MODEL_ELEMENT.toPrint(matchedTargets)});
                if (matchedTargets.isEmpty()) {
                    unmatchedSources.add(sourceRepresentative);
                    sourceGenerationReady.remove(sourceRepresentative);
                    continue;
                }
                Node<RefObject> targetRepresentative = matchedTargets.get(0);
                List matchedSources = Node.findReadyMatches(equivalenceClasses, targetRepresentative, sourceGenerationReady);
                LOGGER.log(Level.FINER, "Matching {0} found at the source side {1}", new Object[]{PRINT_MODEL_ELEMENT.toPrint(targetRepresentative), PRINT_MODEL_ELEMENT.toPrint(matchedSources)});
                assert (matchedSources.contains(sourceRepresentative)) : "Expected this node pertains to its equivalence class";
                equivalenceClasses.add((RefObject)Node.unwrap(matchedSources), (RefObject)Node.unwrap(matchedTargets));
                targetGenerationReady.removeAll(matchedTargets);
                sourceGenerationReady.removeAll(matchedSources);
                collectedMatchedSources.addAll(matchedSources);
                collectedMatchedTargets.addAll(matchedTargets);
            }
            LOGGER.log(Level.FINE, "Iteartion {0}, found as deleted: {1}", new Object[]{iteration, PRINT_MODEL_ELEMENT.toPrint(unmatchedSources)});
            LOGGER.log(Level.FINE, "Iteartion {0}, found as added: {1}", new Object[]{iteration, PRINT_MODEL_ELEMENT.toPrint(targetGenerationReady)});
            sourceTopology.removeFromReadyNodes(unmatchedSources);
            unmatchedSources.clear();
            targetTopology.removeFromReadyNodes(targetGenerationReady);
            targetGenerationReady.clear();
            sourceTopology.removeFromTopology(collectedMatchedSources);
            targetTopology.removeFromTopology(collectedMatchedTargets);
            collectedMatchedSources.clear();
            collectedMatchedTargets.clear();
            sourceGenerationReady = sourceTopology.getGenerationOfReady();
            targetGenerationReady = targetTopology.getGenerationOfReady();
        }
    }

    private void detectElementChanges(List<InstanceDifference> exactMatches, List<InstanceDifference> changes, EquivalenceClassesMap<RefObject> equivalenceClasses) {
        equivalenceClasses.getXKeys().forEach(xRepresentative -> this.compareRepresentatives((RefObject)xRepresentative, exactMatches, changes, equivalenceClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareRepresentatives(RefObject xRepresentative, List<InstanceDifference> exactMatches, List<InstanceDifference> changes, EquivalenceClassesMap<RefObject> equivalenceClasses) {
        List<InstanceDifference> list;
        Collection attributeNames = (Collection)this.retrieveAttributes.execute((Object)xRepresentative);
        attributeNames.removeAll(this.exceptionMatchCriteria.getAttributes(xRepresentative));
        Collection associationNames = (Collection)this.retrieveAssociations.execute((Object)xRepresentative);
        associationNames.removeAll(this.exceptionMatchCriteria.getAssociations(xRepresentative));
        RefObject yRepresentative = equivalenceClasses.map(xRepresentative);
        Collection<CachedModelElement> xEquivalents = CachedModelElement.cacheModel(equivalenceClasses.getEquivalents(xRepresentative), attributeNames, associationNames);
        Collection<CachedModelElement> yEquivalents = CachedModelElement.cacheModel(equivalenceClasses.getEquivalents(yRepresentative), attributeNames, associationNames);
        ArrayList<InstanceDifference> detectedChanges = new ArrayList<InstanceDifference>();
        LOGGER.log(Level.FINE, "Each-to-each comparison of: {0}", new Integer(xEquivalents.size()));
        Iterator<CachedModelElement> xEquivalentIterator = xEquivalents.iterator();
        while (xEquivalentIterator.hasNext()) {
            CachedModelElement xCorrespondent = xEquivalentIterator.next();
            ArrayList<InstanceDifferencesImpl> xDiffs = new ArrayList<InstanceDifferencesImpl>();
            InstanceDifferencesImpl exactMatch = null;
            Iterator<CachedModelElement> yEquivalentIterator = yEquivalents.iterator();
            while (exactMatch == null && yEquivalentIterator.hasNext()) {
                CachedModelElement yCorrespondent = yEquivalentIterator.next();
                InstanceDifferencesImpl diff = new InstanceDifferencesImpl(xCorrespondent, yCorrespondent, equivalenceClasses);
                if (diff.isExactMatch()) {
                    exactMatch = diff;
                    continue;
                }
                xDiffs.add(diff);
            }
            if (exactMatch != null) {
                yEquivalentIterator.remove();
                xEquivalentIterator.remove();
                exactMatch.removeCoveredDiffs(detectedChanges);
                xDiffs.clear();
                list = exactMatches;
                synchronized (list) {
                    exactMatches.add(exactMatch);
                    continue;
                }
            }
            detectedChanges.addAll(xDiffs);
        }
        list = changes;
        synchronized (list) {
            changes.addAll(this.filterOutRepeated(detectedChanges));
        }
    }

    private List<InstanceDifference> filterOutRepeated(List<InstanceDifference> detectedChanges) {
        ArrayList<InstanceDifference> result = new ArrayList<InstanceDifference>();
        while (!detectedChanges.isEmpty()) {
            InstanceDifference diff = detectedChanges.remove(0);
            result.add(diff);
            diff.removeCoveredDiffs(detectedChanges);
        }
        return result;
    }
}

