/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.model.Association;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.AssociationName;
import net.mdatools.modelant.core.api.name.ClassName;
import net.mdatools.modelant.core.api.name.FieldName;
import net.mdatools.modelant.core.name.AssociationNameImpl;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.core.name.FieldNameImpl;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.util.Navigator;

public class CopyToMetaModel
implements Function<RefPackage, Map<RefObject, RefObject>> {
    private static final Logger LOGGER = Logger.getLogger(CopyToMetaModel.class.getPackage().getName());
    private final NameMapping nameMapping;
    private final RefPackage sourceExtent;

    public CopyToMetaModel(RefPackage sourceExtent, NameMapping mapping) {
        this.nameMapping = mapping;
        if (sourceExtent == null) {
            throw new IllegalArgumentException("Expected a non-null source extent to transform");
        }
        this.sourceExtent = sourceExtent;
    }

    public Map<RefObject, RefObject> execute(RefPackage targetExtent) {
        if (targetExtent == null) {
            throw new IllegalArgumentException("Expected a non-null target extent to copy to");
        }
        IdentityHashMap<RefObject, RefObject> result = new IdentityHashMap<RefObject, RefObject>();
        for (RefClass refClass : Navigator.getAllClasses(this.sourceExtent)) {
            this.copyObjects(targetExtent, refClass, result);
        }
        for (RefClass refClass : Navigator.getAllClasses(this.sourceExtent)) {
            this.copyAttributes(targetExtent, refClass, result);
        }
        for (RefAssociation refAssociation : Navigator.getAllAssociations(this.sourceExtent)) {
            this.copyLinks(targetExtent, refAssociation, result);
        }
        return result;
    }

    private void copyObjects(RefPackage targetExtent, RefClass originalMetaClass, Map<RefObject, RefObject> objectsMap) {
        ClassNameImpl className = new ClassNameImpl((Classifier)originalMetaClass.refMetaObject());
        Procedure construct = this.nameMapping.mapMetaClass((ClassName)className, this.sourceExtent, targetExtent, objectsMap);
        for (RefObject source : originalMetaClass.refAllOfClass()) {
            try {
                construct.execute((Object)source);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Copy object " + new PrintModelElement().execute(source) + " caused: ", ex);
            }
        }
    }

    private void copyAttributes(RefPackage targetExtent, RefClass originalMetaClass, Map<RefObject, RefObject> objectsMap) {
        Collection<Procedure<RefObject>> copyAttributesOperations = this.collectCopyAttributeOperations(originalMetaClass, targetExtent, objectsMap);
        for (RefObject source : originalMetaClass.refAllOfClass()) {
            for (Procedure<RefObject> copy : copyAttributesOperations) {
                try {
                    copy.execute((Object)source);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, copy + " on " + new PrintModelElement().execute(source) + " caused: ", ex);
                }
            }
        }
    }

    private Collection<Procedure<RefObject>> collectCopyAttributeOperations(RefClass originalModelClass, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap) {
        ArrayList<Procedure<RefObject>> result = new ArrayList<Procedure<RefObject>>();
        Classifier sourceMetaObject = (Classifier)originalModelClass.refMetaObject();
        Collection<Classifier> superMetaObjects = Navigator.getAllSuperMetaObejcts(sourceMetaObject);
        for (Classifier superclass : superMetaObjects) {
            for (ModelElement contents : superclass.getContents()) {
                if (!(contents instanceof Attribute)) continue;
                FieldNameImpl sourceFieldName = new FieldNameImpl((Attribute)contents);
                result.add((Procedure<RefObject>)this.nameMapping.mapMetaFieldName((FieldName)sourceFieldName, this.sourceExtent, targetExtent, objectsMap));
            }
        }
        return result;
    }

    private void copyLinks(RefPackage targetExtent, RefAssociation sourceAssociation, Map<RefObject, RefObject> objectsMap) {
        AssociationNameImpl className = new AssociationNameImpl((Association)sourceAssociation.refMetaObject());
        Procedure copyLinkOperation = this.nameMapping.mapMetaAssociation((AssociationName)className, this.sourceExtent, targetExtent, objectsMap);
        for (RefAssociationLink source : sourceAssociation.refAllLinks()) {
            try {
                copyLinkOperation.execute((Object)source);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Copying link " + new PrintModelElement().execute(source) + " caused: ", ex);
            }
        }
    }
}

