/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import net.mdatools.modelant.core.api.diff.AssociationDifference;
import net.mdatools.modelant.core.api.diff.InstanceDifference;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.operation.model.CachedModelElement;
import net.mdatools.modelant.core.operation.model.topology.EquivalenceClassesMap;

class InstanceDifferencesImpl
implements InstanceDifference {
    private final List<String> attributesWithDifferences = new ArrayList<String>();
    private final List<AssociationDifference> associationDiffs = new ArrayList<AssociationDifference>();
    private final CachedModelElement xObject;
    private final CachedModelElement yObject;
    private final EquivalenceClassesMap<RefObject> correspondents;
    private final Iterator<String> attributesIterator;
    private final Iterator<String> associationsIterator;
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement("  ");
    private static final PrintModelElement PRINT_NESTED_MODEL_ELEMENT = new PrintModelElement("    ");

    InstanceDifferencesImpl(CachedModelElement xCorrespondent, CachedModelElement yCorrespondent, EquivalenceClassesMap<RefObject> correspondents) {
        this.xObject = xCorrespondent;
        this.yObject = yCorrespondent;
        this.correspondents = correspondents;
        assert (correspondents.map(this.xObject.getWrapped()) == correspondents.getRepresentative(this.yObject.getWrapped())) : "Expected x and y pertain to mapped equivalence classes";
        assert (this.xObject.getAssociationNames().equals(this.yObject.getAssociationNames())) : "The compared objects should have the same set of association names";
        assert (this.xObject.getAttributeNames().equals(this.yObject.getAttributeNames())) : "The compared objects should have the same set of attribute names";
        this.attributesIterator = this.xObject.getAttributeNames().iterator();
        this.associationsIterator = this.xObject.getAssociationNames().iterator();
    }

    public boolean isExactMatch() {
        ShouldSuspendDiff suspendOnAnyChange = new ShouldSuspendDiff(){

            @Override
            public boolean shouldSuspend() {
                return !InstanceDifferencesImpl.this.attributesWithDifferences.isEmpty() || !InstanceDifferencesImpl.this.associationDiffs.isEmpty();
            }
        };
        this.compareFeatures(suspendOnAnyChange);
        this.compareAssociations(suspendOnAnyChange);
        return this.attributesWithDifferences.isEmpty() && this.associationDiffs.isEmpty();
    }

    public void completeChangeDetection() {
        ShouldSuspendDiff neverSuspend = new ShouldSuspendDiff(){

            @Override
            public boolean shouldSuspend() {
                return false;
            }
        };
        this.compareFeatures(neverSuspend);
        this.compareAssociations(neverSuspend);
    }

    private void compareFeatures(ShouldSuspendDiff whenToSuspend) {
        while (!whenToSuspend.shouldSuspend() && this.attributesIterator.hasNext()) {
            Object oldValue;
            String attributeName = this.attributesIterator.next();
            Object newValue = this.xObject.getAttributeValue(attributeName);
            if (newValue == (oldValue = this.yObject.getAttributeValue(attributeName)) || newValue != null && oldValue != null && PRINT_MODEL_ELEMENT.execute(newValue).equals(PRINT_MODEL_ELEMENT.execute(oldValue))) continue;
            this.attributesWithDifferences.add(attributeName);
        }
    }

    private void compareAssociations(ShouldSuspendDiff whenToSuspend) {
        while (!whenToSuspend.shouldSuspend() && this.associationsIterator.hasNext()) {
            String associationName = this.associationsIterator.next();
            AssociationDiff diff = new AssociationDiff(this.correspondents, associationName, this.xObject.getAssociationValue(associationName), this.yObject.getAssociationValue(associationName));
            if (diff.isEmpty()) continue;
            this.associationDiffs.add(diff);
        }
    }

    public final List<String> getAttributesWithDifferences() {
        return this.attributesWithDifferences;
    }

    public final List<AssociationDifference> getAssociationDiffs() {
        return this.associationDiffs;
    }

    public final RefObject getXObject() {
        return this.xObject.getWrapped();
    }

    public final RefObject getYObject() {
        return this.yObject.getWrapped();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InstanceDifferences {\n");
        if (this.getXObject() != null) {
            builder.append("  xObject=").append(PRINT_MODEL_ELEMENT.execute(this.getXObject())).append(",\n");
        }
        if (this.getYObject() != null) {
            builder.append("  yObject=").append(PRINT_MODEL_ELEMENT.execute(this.getYObject())).append(",\n");
        }
        if (this.attributesWithDifferences != null) {
            builder.append("  attributesWithDifferences=").append(this.attributesWithDifferences).append(",\n");
        }
        if (this.associationDiffs != null) {
            builder.append("  associationDiffs=").append(this.associationDiffs).append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private static interface ShouldSuspendDiff {
        public boolean shouldSuspend();
    }

    private static class AssociationDiff
    implements AssociationDifference {
        private final String associationName;
        private final List<RefObject> xMinusY = new ArrayList<RefObject>();
        private final List<RefObject> yMinusX = new ArrayList<RefObject>();

        public AssociationDiff(EquivalenceClassesMap<RefObject> correspondents, String associationName, Object xAssociated, Object yAssociated) {
            this.associationName = associationName;
            if (xAssociated instanceof Collection) {
                Set<RefObject> yAssociatedRepresentatives = correspondents.getRepresentativesOrSelf((Collection)yAssociated);
                Set<RefObject> xAssociatedRepresentatives = correspondents.getRepresentativesOrSelf((Collection)xAssociated);
                for (RefObject xRepresentative : xAssociatedRepresentatives) {
                    if (yAssociatedRepresentatives.contains(correspondents.map(xRepresentative))) continue;
                    this.xMinusY.add(xRepresentative);
                }
                for (RefObject yRepresentative : yAssociatedRepresentatives) {
                    if (xAssociatedRepresentatives.contains(correspondents.map(yRepresentative))) continue;
                    this.yMinusX.add(yRepresentative);
                }
            } else if (xAssociated != null) {
                if (yAssociated == null) {
                    this.xMinusY.add((RefObject)xAssociated);
                } else {
                    RefObject mapped = correspondents.map((RefObject)xAssociated);
                    if (mapped != correspondents.getRepresentative((RefObject)yAssociated)) {
                        this.xMinusY.add((RefObject)xAssociated);
                        this.yMinusX.add((RefObject)yAssociated);
                    }
                }
            } else if (yAssociated != null) {
                this.yMinusX.add((RefObject)yAssociated);
            }
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        public final List<RefObject> getXMinusY() {
            return this.xMinusY;
        }

        public final List<RefObject> getYMinusX() {
            return this.yMinusX;
        }

        public boolean isEmpty() {
            return this.xMinusY.isEmpty() && this.yMinusX.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AssociationDiff {\n");
            if (this.associationName != null) {
                builder.append("    associationName=").append(this.associationName).append(",\n");
            }
            if (this.xMinusY != null) {
                builder.append("    xMinusY=").append(PRINT_NESTED_MODEL_ELEMENT.execute(this.xMinusY)).append(",\n");
            }
            if (this.yMinusX != null) {
                builder.append("    yMinusX=").append(PRINT_NESTED_MODEL_ELEMENT.execute(this.yMinusX)).append("\n");
            }
            builder.append("}");
            return builder.toString();
        }
    }
}

