/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.List;
import javax.jmi.reflect.RefObject;
import net.mdatools.modelant.core.api.diff.InstanceDifference;
import net.mdatools.modelant.core.api.diff.ModelComparisonResult;
import net.mdatools.modelant.core.api.diff.ModelDifference;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.operation.model.ModelDifferenceImpl;

class ModelComparisonResultImpl
implements ModelComparisonResult {
    static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private final List<ModelDifference> deleted;
    private final List<ModelDifference> added;
    private final List<InstanceDifference> changed;
    private final List<InstanceDifference> exactMatches;
    private final MatchingCriteria matchingCriteria;

    public ModelComparisonResultImpl(MatchingCriteria matchingCriteria, List<RefObject> added, List<RefObject> deleted, List<InstanceDifference> changes, List<InstanceDifference> exactMatches) {
        assert (matchingCriteria != null) : "Expected non-null matching criteria";
        assert (added != null) : "Expected non-null added obects";
        assert (deleted != null) : "Expected non-null deleted obects";
        assert (changes != null) : "Expected non-null obect differences";
        assert (exactMatches != null) : "Expected non-null exactly matched objects";
        this.matchingCriteria = matchingCriteria;
        this.deleted = ModelDifferenceImpl.findModelDifferences(deleted, matchingCriteria);
        this.added = ModelDifferenceImpl.findModelDifferences(added, matchingCriteria);
        this.changed = changes;
        this.exactMatches = exactMatches;
    }

    public final List<ModelDifference> getDeleted() {
        return this.deleted;
    }

    public final List<ModelDifference> getAdded() {
        return this.added;
    }

    public final List<InstanceDifference> getChanged() {
        return this.changed;
    }

    public List<InstanceDifference> getExactlyMatched() {
        return this.exactMatches;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModelComparisonResult {\r\n");
        builder.append("matchingCcriteria=");
        builder.append(this.matchingCriteria);
        builder.append(",\r\n");
        if (this.deleted != null) {
            builder.append("deleted=");
            builder.append(this.deleted);
            builder.append(",\r\n");
        }
        if (this.added != null) {
            builder.append("added=");
            builder.append(this.added);
            builder.append(",\r\n");
        }
        if (this.changed != null) {
            builder.append("changed=");
            builder.append(this.changed);
            builder.append(",\r\n");
        }
        if (this.exactMatches != null) {
            builder.append("exactMatches=");
            builder.append(this.exactMatches);
            builder.append(",\r\n");
            builder.append(this.exactMatches.size() + "  elements");
            builder.append("\r\n");
        }
        builder.append("}");
        return builder.toString();
    }

    public MatchingCriteria getMatchingCriteria() {
        return this.matchingCriteria;
    }
}

