/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import net.mdatools.modelant.core.api.diff.ModelDifference;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.operation.model.ModelComparisonResultImpl;
import net.mdatools.modelant.core.util.Navigator;
import net.mdatools.modelant.core.util.map.MapToList;

class ModelDifferenceImpl
implements ModelDifference {
    private static final Logger LOGGER = Logger.getLogger(ModelDifferenceImpl.class.getPackage().getName());
    private final RefObject wrapped;
    private final MapToList<String, ModelDifference> associations = new MapToList();

    public ModelDifferenceImpl(RefObject element) {
        this.wrapped = element;
    }

    public RefObject getElement() {
        return this.wrapped;
    }

    public Map<String, Collection<ModelDifference>> getAssociations() {
        return this.associations.toMap();
    }

    public static List<ModelDifference> findModelDifferences(List<RefObject> all, MatchingCriteria matchingCriteria) {
        HashMap<RefObject, ModelDifferenceImpl> mapElementDifference = new HashMap<RefObject, ModelDifferenceImpl>();
        for (RefObject element : all) {
            mapElementDifference.put(element, new ModelDifferenceImpl(element));
        }
        ArrayList<ModelDifference> result = new ArrayList<ModelDifference>();
        for (ModelDifferenceImpl difference : mapElementDifference.values()) {
            boolean isRoot = difference.bindToParentDifferences(mapElementDifference, matchingCriteria);
            if (!isRoot) continue;
            result.add(difference);
        }
        return result;
    }

    private boolean bindToParentDifferences(Map<RefObject, ModelDifferenceImpl> mapElementDifference, MatchingCriteria matchingCriteria) {
        boolean result = true;
        for (String association : matchingCriteria.getAssociations(this.getElement())) {
            try {
                List<? extends Object> associated = Navigator.collectValues((RefFeatured)this.getElement(), association, LOGGER.isLoggable(Level.FINE));
                for (RefObject refObject : associated) {
                    ModelDifferenceImpl parent = mapElementDifference.get(refObject);
                    if (parent == null) continue;
                    result = false;
                    parent.add(association, this);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Model element: {0} does not support association: {1}", new Object[]{ModelComparisonResultImpl.PRINT_MODEL_ELEMENT.execute(this.getElement()), association});
            }
        }
        return result;
    }

    private void add(String association, ModelDifference difference) {
        this.associations.put(association, difference);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(128);
        result.append("{\r\n element: ").append(new PrintModelElement().execute(this.wrapped));
        if (!this.associations.isEmpty()) {
            for (Map.Entry entry : this.associations.entrySet()) {
                result.append(",\r\n being ").append((String)entry.getKey()).append(" of:").append(entry.getValue());
            }
        }
        result.append("\r\n}");
        return result.toString();
    }
}

