/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.export;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import net.mdatools.modelant.core.api.diff.AssociationDifference;
import net.mdatools.modelant.core.api.diff.Export;
import net.mdatools.modelant.core.api.diff.InstanceDifference;
import net.mdatools.modelant.core.api.diff.ModelComparisonResult;
import net.mdatools.modelant.core.api.diff.ModelDifference;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.util.Navigator;

public class StructuredTextExport
implements Export {
    private static final String INDENT = "  ";
    private static final String ATTRIBUTE_QUALIFIED_NAME = "qualifiedName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(ModelComparisonResult modelDiff) {
        StringWriter result = new StringWriter();
        try (PrintWriter out = new PrintWriter(result);){
            out.println("{");
            out.print(INDENT);
            out.print("deleted = ");
            this.exportModelDiff(out, this.indent(6), modelDiff.getDeleted());
            out.println(",");
            out.print(INDENT);
            out.print("added = ");
            this.exportModelDiff(out, this.indent(6), modelDiff.getAdded());
            out.println(",");
            out.print(INDENT);
            out.print("changed = ");
            this.exportInstances(out, this.indent(6), modelDiff.getChanged());
            out.println(",");
            out.print(INDENT);
            out.print("exactMatch = ");
            this.exportInstances(out, this.indent(6), modelDiff.getExactlyMatched());
            out.println(",");
            out.print(INDENT);
            out.print("exactMatchSize = ");
            out.print(modelDiff.getExactlyMatched().size());
            out.println();
            out.println("}");
        }
        System.out.println(result.toString());
    }

    private void export(PrintWriter out, String indent, InstanceDifference diff) {
        PrintModelElement print = new PrintModelElement(indent + this.indent(6));
        out.print(indent);
        out.println("{");
        out.print(indent);
        out.print("xObject = ");
        out.print(print.execute(diff.getXObject()));
        out.println(",");
        out.print(indent);
        out.print("yObject = ");
        out.print(print.execute(diff.getYObject()));
        out.println(",");
        out.print(indent);
        out.print("attributesWithDifferences = ");
        out.print(diff.getAttributesWithDifferences());
        out.println(",");
        out.print(indent);
        out.print("associationDiffs =");
        this.export(out, indent + this.indent(6), diff.getAssociationDiffs());
        out.print("}");
    }

    private void export(PrintWriter out, String indent, ModelDifference diff) {
        out.print(indent);
        out.print("{ ");
        out.print(new PrintModelElement(indent + this.indent(2)).execute(diff.getElement()));
        Map associations = diff.getAssociations();
        for (Map.Entry entry : associations.entrySet()) {
            out.println(",");
            out.print(indent + INDENT);
            out.print("in the role of ");
            out.print((String)entry.getKey());
            out.print(" for ");
            this.exportModelDiff(out, indent + this.indent(5), (Collection)entry.getValue());
        }
        out.print("}");
    }

    private void export(PrintWriter out, String indent, List<AssociationDifference> diffs) {
        PrintModelElement print = new PrintModelElement(indent + this.indent(6));
        out.print("{");
        boolean first = true;
        for (AssociationDifference diff : diffs) {
            if (!first) {
                out.print(",");
            }
            first = false;
            out.println();
            out.print(indent);
            out.print("{");
            out.print("associationName = ");
            out.print(diff.getAssociationName());
            out.println(",");
            out.print(indent);
            out.print("xMinusY = ");
            out.print(print.execute(diff.getXMinusY()));
            out.println(",");
            out.print(indent);
            out.print("yMinusX = ");
            out.print(print.execute(diff.getYMinusX()));
            out.print("}");
        }
        out.print("}");
    }

    private void exportModelDiff(PrintWriter out, String indent, Collection<ModelDifference> diffs) {
        ArrayList<ModelDifference> sorted = new ArrayList<ModelDifference>(diffs);
        Collections.sort(sorted, new OrderModelDifferences());
        out.print("{");
        boolean first = true;
        for (ModelDifference diff : sorted) {
            if (!first) {
                out.print(",");
            }
            first = false;
            out.println();
            this.export(out, indent, diff);
        }
        out.print("}");
    }

    private void exportInstances(PrintWriter out, String indent, List<InstanceDifference> diffs) {
        Collections.sort(diffs, new OrderInstanceDifferences());
        out.println("{");
        boolean first = true;
        for (InstanceDifference diff : diffs) {
            if (!first) {
                out.print(",");
            }
            first = false;
            out.println();
            this.export(out, indent, diff);
        }
        out.print("}");
    }

    private String indent(int steps) {
        StringBuilder result = new StringBuilder(128);
        for (int i = 0; i < steps; ++i) {
            result.append(INDENT);
        }
        return result.toString();
    }

    static int orderModelElements(RefObject element1, RefObject element2) {
        int result = Navigator.getMetaClassName(element1).compareTo(Navigator.getMetaClassName(element2));
        if (result == 0) {
            result = StructuredTextExport.getQualifiedName(element1).compareTo(StructuredTextExport.getQualifiedName(element2));
        }
        return result;
    }

    private static String getQualifiedName(RefObject element) {
        String result;
        try {
            result = element.refGetValue(ATTRIBUTE_QUALIFIED_NAME).toString();
        }
        catch (Exception ex) {
            result = "";
        }
        return result;
    }

    static class OrderInstanceDifferences
    implements Comparator<InstanceDifference> {
        OrderInstanceDifferences() {
        }

        @Override
        public int compare(InstanceDifference o1, InstanceDifference o2) {
            return StructuredTextExport.orderModelElements(o1.getXObject(), o2.getXObject());
        }
    }

    static class OrderModelDifferences
    implements Comparator<ModelDifference> {
        OrderModelDifferences() {
        }

        @Override
        public int compare(ModelDifference o1, ModelDifference o2) {
            return StructuredTextExport.orderModelElements(o1.getElement(), o2.getElement());
        }
    }
}

