/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mdatools.modelant.core.operation.model.topology.EquivalenceClassesMap;

public class EquivalenceClassesMapImpl<V>
implements EquivalenceClassesMap<V> {
    private final Map<V, V> elementToKey = new IdentityHashMap<V, V>();
    private final Map<V, V> keyToKey = new IdentityHashMap<V, V>();
    private final List<V> xKeys = new ArrayList<V>();

    @Override
    public void add(Collection<V> xClass, Collection<V> yClass) {
        assert (xClass != null) : "Expected not null xClass";
        assert (!xClass.isEmpty()) : "Expected not empty xClass";
        assert (yClass != null) : "Expected not null yClass";
        assert (!yClass.isEmpty()) : "Expected not empty yClass";
        Iterator<V> xIterator = xClass.iterator();
        Iterator<V> yIterator = yClass.iterator();
        V x = xIterator.next();
        V y = yIterator.next();
        this.add(x, y);
        while (xIterator.hasNext()) {
            this.add(xIterator.next(), y);
        }
        while (yIterator.hasNext()) {
            this.add(x, yIterator.next());
        }
    }

    @Override
    public final void add(V x, V y) throws IllegalArgumentException {
        V xRep = this.getRepresentative(x);
        V yRep = this.getRepresentative(y);
        if (xRep == null) {
            if (yRep == null) {
                this.elementToKey.put(x, x);
                this.elementToKey.put(y, y);
                this.keyToKey.put(x, y);
                this.keyToKey.put(y, x);
                this.xKeys.add(x);
            } else {
                this.elementToKey.put(x, this.keyToKey.get(yRep));
            }
        } else if (yRep == null) {
            this.elementToKey.put(y, this.keyToKey.get(xRep));
        } else if (yRep != this.keyToKey.get(xRep)) {
            throw new IllegalArgumentException("Expected " + x + " with its representative " + xRep + " is mapped to be mapped to the representative of " + yRep + " of " + y);
        }
    }

    @Override
    public final Collection<V> getXKeys() {
        return this.xKeys;
    }

    @Override
    public final Collection<V> getEquivalents(V element) {
        ArrayList<V> result = new ArrayList<V>();
        V representative = this.elementToKey.get(element);
        for (Map.Entry<V, V> entry : this.elementToKey.entrySet()) {
            if (entry.getValue() != representative) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public final V getRepresentative(V element) {
        return this.elementToKey.get(element);
    }

    @Override
    public final V map(V element) {
        V result = this.keyToKey.get(this.getRepresentative(element));
        return result;
    }
}

