/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.model.topology.Key;
import net.mdatools.modelant.core.operation.model.topology.Node;
import net.mdatools.modelant.core.util.map.MapToCollection;
import net.mdatools.modelant.core.util.map.MapToSet;

public class ModelTopology {
    private final MapToCollection<Key, Node<RefObject>> nodes = new MapToSet<Key, Node<RefObject>>();
    private final List<Node<RefObject>> readyNodes = new ArrayList<Node<RefObject>>();
    private final Map<RefObject, Node<RefObject>> elementToNodeMap = new IdentityHashMap<RefObject, Node<RefObject>>(101);

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void load(MatchingCriteria criteria, Collection<RefObject> elements) {
        assert (criteria != null) : "Expected non-null criteria";
        for (RefObject element : elements) {
            Node<RefObject> node = new Node<RefObject>(element, criteria);
            this.elementToNodeMap.put(element, node);
        }
        for (Node<RefObject> node : this.elementToNodeMap.values()) {
            node.assignAssociatedNodes(this.elementToNodeMap);
            this.add(node);
        }
    }

    private void add(Node<RefObject> node) {
        this.nodes.put(node.getKey(), node);
        if (node.isReady()) {
            this.readyNodes.add(node);
        }
    }

    public final ArrayList<Node<RefObject>> getGenerationOfReady() {
        return new ArrayList<Node<RefObject>>(this.readyNodes);
    }

    public final void remove(Collection<RefObject> equivalents) {
        for (RefObject element : equivalents) {
            this.removeFromTopology(this.elementToNodeMap.get(element));
        }
    }

    public void removeFromTopology(Collection<Node<RefObject>> nodes) {
        for (Node<RefObject> node : new ArrayList<Node<RefObject>>(nodes)) {
            this.removeFromTopology(node);
        }
    }

    private void removeFromTopology(Node<RefObject> node) {
        boolean actuallyRemoved = this.remove(node);
        assert (actuallyRemoved) : "Expected a node that existed in this topology " + node;
        for (Node<RefObject> referer : node.getReferers()) {
            actuallyRemoved = this.remove(referer);
            if (!actuallyRemoved) continue;
            referer.decreaseLevel();
            this.add(referer);
        }
    }

    private boolean remove(Node<RefObject> node) {
        if (node.isReady()) {
            this.readyNodes.remove(node);
        }
        return this.nodes.remove(node.getKey(), node);
    }

    public void removeFromReadyNodes(List<Node<RefObject>> targetGenerationReady) {
        this.readyNodes.removeAll(targetGenerationReady);
    }

    public List<RefObject> getContents() {
        ArrayList<RefObject> result = new ArrayList<RefObject>();
        for (Node<RefObject> node : this.nodes.values()) {
            result.add(node.getWrapped());
        }
        return result;
    }

    public void clear() {
        this.readyNodes.clear();
        this.nodes.clear();
        this.elementToNodeMap.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.nodes + "}";
    }
}

