/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.match.MatchingCriteria;
import net.mdatools.modelant.core.operation.element.PrintElementRestricted;
import net.mdatools.modelant.core.operation.element.PrintModelElement;
import net.mdatools.modelant.core.operation.model.topology.EquivalenceClassesMap;
import net.mdatools.modelant.core.operation.model.topology.Key;
import net.mdatools.modelant.core.util.Navigator;
import net.mdatools.modelant.core.util.key.Hash;

public class Node<V extends RefObject> {
    private static Logger LOGGER = Logger.getLogger(Node.class.getPackage().getName());
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private final V wrapped;
    private final Map<String, List<String>> attributeValues = new HashMap<String, List<String>>(3);
    private final int attributesHash;
    private final Map<String, Collection<V>> referredModelElements = new HashMap<String, Collection<V>>(3);
    private final List<Node<V>> referers = new ArrayList<Node<V>>();
    private final MatchingCriteria criteria;
    private int level;
    private Key key;

    public Node(V wrapped, MatchingCriteria criteria) {
        this.wrapped = wrapped;
        this.criteria = criteria;
        this.level = 0;
        int valuesHash = 0;
        for (String attribute : criteria.getAttributes(wrapped)) {
            valuesHash <<= 1;
            try {
                List<? extends Object> values = Navigator.collectValues(wrapped, attribute, LOGGER.isLoggable(Level.FINE));
                ArrayList<String> printableValues = new ArrayList<String>();
                for (Object object : values) {
                    String stringValue;
                    if (object instanceof RefBaseObject || object instanceof RefStruct) {
                        stringValue = PRINT_MODEL_ELEMENT.execute(object);
                        valuesHash += Hash.hash(stringValue);
                        printableValues.add(stringValue);
                        continue;
                    }
                    if (object == null) continue;
                    stringValue = object.toString();
                    valuesHash += Hash.hash(stringValue);
                    printableValues.add(stringValue);
                }
                this.attributeValues.put(attribute, printableValues);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Model element: {0} does not support attribute: {1}", new Object[]{PRINT_MODEL_ELEMENT.execute(this.getWrapped()), attribute});
            }
        }
        this.attributesHash = valuesHash;
        this.assignKey();
    }

    private void assignKey() {
        this.key = new Key((RefObject)this.getWrapped(), this.getLevel(), this.attributesHash);
    }

    public void assignAssociatedNodes(Map<V, Node<V>> modelToNodeMap) {
        for (String association : this.criteria.getAssociations(this.getWrapped())) {
            try {
                List<? extends Object> associated = Navigator.collectValues(this.wrapped, association, LOGGER.isLoggable(Level.FINE));
                for (RefObject refObject : associated) {
                    Node<V> associatedNode = modelToNodeMap.get(refObject);
                    assert (associatedNode != null) : "Expected a node bound for object " + PRINT_MODEL_ELEMENT.execute(refObject);
                    ++this.level;
                    associatedNode.referers.add(this);
                }
                this.referredModelElements.put(association, associated);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Model element: {0} does not support association: {1}", new Object[]{PRINT_MODEL_ELEMENT.execute(this.getWrapped()), association});
            }
        }
    }

    public static <V extends RefObject> List<Node<V>> findReadyMatches(EquivalenceClassesMap<V> equivalenceClasses, Node<V> nodeToMatch, List<Node<V>> generationReady) {
        ArrayList<Node<V>> result = new ArrayList<Node<V>>();
        assert (nodeToMatch.isReady()) : "Expected a ready node " + nodeToMatch;
        for (Node<V> target : generationReady) {
            if (!nodeToMatch.getKey().equals(target.getKey()) || !super.matches(target, equivalenceClasses)) continue;
            result.add(target);
        }
        return result;
    }

    private boolean matches(Node otherNode, EquivalenceClassesMap<V> equivalenceClasses) {
        assert (this.getLevel() == 0) : "Expeceted only level 0 objects are matched from, instead of " + this.getLevel();
        assert (otherNode.getLevel() == 0) : "Expeceted only level 0 objects are matched to, instead of " + otherNode.getLevel();
        boolean result = this.attributesHash == otherNode.attributesHash;
        Iterator<Map.Entry<String, List<String>>> attributeEntriesIterator = this.attributeValues.entrySet().iterator();
        while (result && attributeEntriesIterator.hasNext()) {
            Map.Entry<String, List<String>> entry = attributeEntriesIterator.next();
            List<String> thisAttributeValue = entry.getValue();
            List<String> otherAttributeValue = otherNode.attributeValues.get(entry.getKey());
            result = ((Object)thisAttributeValue).equals(otherAttributeValue);
        }
        Iterator<String> associationNamesIterator = this.referredModelElements.keySet().iterator();
        while (result && associationNamesIterator.hasNext()) {
            String thisAssociationName = associationNamesIterator.next();
            Set<V> theseMappedRepersentatives = equivalenceClasses.getMappedRepresentatives(this.referredModelElements(thisAssociationName));
            Set<V> otherRepersentatives = equivalenceClasses.getRepresentatives(otherNode.referredModelElements(thisAssociationName));
            result = theseMappedRepersentatives.equals(otherRepersentatives);
        }
        return result;
    }

    private Collection<V> referredModelElements(String associationName) {
        Set result = this.referredModelElements.get(associationName);
        if (result == null) {
            result = Collections.EMPTY_SET;
        }
        return result;
    }

    public void decreaseLevel() {
        --this.level;
        assert (this.level >= 0) : "Expected a non-negative number of objects this refers to";
        this.assignKey();
    }

    public final List<Node<V>> getReferers() {
        return this.referers;
    }

    private int getLevel() {
        return this.level;
    }

    public final boolean isReady() {
        return this.level == 0;
    }

    public final V getWrapped() {
        return this.wrapped;
    }

    final Key getKey() {
        return this.key;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Node ").append(this.level).append(" ").append(new PrintElementRestricted("  ", this.criteria).execute(this.wrapped));
        return result.toString();
    }

    public static <V extends RefObject> Collection<V> unwrap(List<Node<V>> nodes) {
        ArrayList<V> result = new ArrayList<V>();
        for (Node<V> node : nodes) {
            result.add(node.getWrapped());
        }
        return result;
    }
}

