/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.transform;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefEnum;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Operation;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.EnumValueName;
import net.mdatools.modelant.core.api.name.StructName;
import net.mdatools.modelant.core.name.EnumValueNameImpl;
import net.mdatools.modelant.core.name.StructNameImpl;
import net.mdatools.modelant.core.operation.element.PrintModelElement;

public class CopyAttributeImpl
implements Procedure<RefObject> {
    private static final Logger LOGGER = Logger.getLogger(CopyAttributeImpl.class.getName());
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    private final String sourceName;
    private final String targetName;
    private final Map<RefObject, RefObject> objectsMap;
    private final RefPackage sourceExtent;
    private final RefPackage targetExtent;
    private final NameMapping valueMapping;

    public CopyAttributeImpl(String sourceName, String targetName, Map<RefObject, RefObject> objectsMap, RefPackage sourceExtent, RefPackage targetExtent, NameMapping valueMapping) {
        this.sourceName = sourceName;
        this.targetName = targetName;
        this.objectsMap = objectsMap;
        this.sourceExtent = sourceExtent;
        this.targetExtent = targetExtent;
        this.valueMapping = valueMapping;
    }

    public void execute(RefObject source) throws IllegalArgumentException {
        RefObject target = this.objectsMap.get(source);
        if (target != null) {
            Object sourceValue;
            try {
                sourceValue = source.refGetValue(this.sourceName);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Getting '" + this.sourceName + "' attribute of object " + PRINT_MODEL_ELEMENT.execute(source) + " instance of " + PRINT_MODEL_ELEMENT.execute(source.refMetaObject()) + " failed with: ", ex);
            }
            if (sourceValue instanceof RefStruct) {
                this.assignStructValue((RefStruct)sourceValue, target);
            } else if (sourceValue instanceof RefEnum) {
                this.assignEnumValue((RefEnum)sourceValue, target);
            } else if (sourceValue instanceof RefObject) {
                this.assignObjectVlaue((RefObject)sourceValue, target);
            } else if (sourceValue != null) {
                this.setValue(sourceValue, target);
            }
        }
    }

    private void assignStructValue(RefStruct sourceStruct, RefObject target) {
        Operation operation = this.valueMapping.mapStruct((StructName)new StructNameImpl(this.sourceExtent, sourceStruct), this.targetExtent, this.objectsMap);
        try {
            RefStruct targetStruct = (RefStruct)operation.execute((Object)sourceStruct);
            this.setValue(targetStruct, target);
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Mapping source struct " + PRINT_MODEL_ELEMENT.execute(sourceStruct) + " caused:", ex);
        }
    }

    private void assignEnumValue(RefEnum sourceValue, RefObject target) {
        EnumValueName targetEnumName = this.valueMapping.mapEnum((EnumValueName)new EnumValueNameImpl(this.sourceExtent, sourceValue));
        if (targetEnumName != null) {
            this.setValue(targetEnumName.lookupValue(this.targetExtent), target);
        } else {
            LOGGER.log(Level.INFO, "The source enum value of " + PRINT_MODEL_ELEMENT.execute(sourceValue) + " is not mapped. Skipped ");
        }
    }

    private void assignObjectVlaue(RefObject sourceValue, RefObject target) {
        RefObject convertedValue = this.objectsMap.get(sourceValue);
        this.setValue(convertedValue, target);
        LOGGER.log(Level.FINE, "{0} mapped to {1}", new Object[]{PRINT_MODEL_ELEMENT.toPrint(sourceValue), PRINT_MODEL_ELEMENT.toPrint(convertedValue)});
    }

    private void setValue(Object convertedValue, RefObject target) {
        try {
            Object targetValue = target.refGetValue(this.targetName);
            if (targetValue instanceof Collection) {
                if (convertedValue instanceof Collection) {
                    ((Collection)targetValue).addAll((Collection)convertedValue);
                } else {
                    ((Collection)targetValue).add(convertedValue);
                }
            } else {
                target.refSetValue(this.targetName, convertedValue);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Setting '" + this.targetName + "' to value: '" + PRINT_MODEL_ELEMENT.execute(convertedValue) + "' on target object " + PRINT_MODEL_ELEMENT.execute(target) + " instance of " + PRINT_MODEL_ELEMENT.execute(target.refMetaObject()) + " failed with: ", ex);
        }
    }

    public String toString() {
        return "Copy from " + this.sourceName + " to " + this.targetName;
    }
}

