/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.operation.model.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Operation;
import net.mdatools.modelant.core.api.Procedure;
import net.mdatools.modelant.core.api.model.ConstructOperation;
import net.mdatools.modelant.core.api.model.ConstructProcedure;
import net.mdatools.modelant.core.api.model.NameMapping;
import net.mdatools.modelant.core.api.name.AssociationName;
import net.mdatools.modelant.core.api.name.ClassName;
import net.mdatools.modelant.core.api.name.EnumValueName;
import net.mdatools.modelant.core.api.name.FieldName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.StructName;
import net.mdatools.modelant.core.name.NameImpl;

public class RenamingMapping
implements NameMapping {
    private static final Logger LOGGER = Logger.getLogger(RenamingMapping.class.getName());
    private final Map<Name<?>, Name<?>> renaming = new HashMap();
    private final Map<Name<?>, ConstructProcedure<?>> nameToMethodMap = new HashMap();
    private final Map<StructName, ConstructOperation<RefStruct>> nameToOperationMap = new HashMap<StructName, ConstructOperation<RefStruct>>();

    protected RenamingMapping() {
    }

    protected final <T extends Name<?>> void set(T key, T name) {
        assert (key != null) : "Expected a non-null key provided";
        assert (!(key instanceof StructName)) : "Expected " + key + " is not a struct name";
        assert (name != null) : "Expected a non-null name provided";
        this.renaming.put(key, name);
        this.nameToMethodMap.remove(key);
    }

    protected final <T extends Name<?>> void unset(T key) {
        this.set(key, NameImpl.NO_MAP_NAME);
    }

    protected final void set(FieldName key, ConstructProcedure<RefObject> translate) {
        assert (key != null) : "Expected a non-null key provided";
        assert (translate != null) : "Expected a non-null translate operation provided";
        this.nameToMethodMap.put((Name<?>)key, translate);
    }

    protected final void set(AssociationName key, ConstructProcedure<RefAssociationLink> translate) {
        assert (key != null) : "Expected a non-null key provided";
        assert (translate != null) : "Expected a non-null translate operation provided";
        this.nameToMethodMap.put((Name<?>)key, translate);
    }

    protected final void setForward(AssociationName key, AssociationName target) {
        assert (key != null) : "Expected a non-null key provided";
        assert (target != null) : "Expected a non-null target provided";
        this.set(key, (ConstructProcedure<RefAssociationLink>)target.newForwardLinkProduction());
    }

    protected final void setBackward(AssociationName key, AssociationName target) {
        assert (key != null) : "Expected a non-null key provided";
        assert (target != null) : "Expected a non-null target provided";
        this.set(key, (ConstructProcedure<RefAssociationLink>)target.newBackwardLinkProduction());
    }

    protected final void set(ClassName key, ConstructProcedure<RefObject> translate) {
        assert (key != null) : "Expected a non-null key provided";
        assert (translate != null) : "Expected a non-null translate operation provided";
        this.nameToMethodMap.put((Name<?>)key, translate);
    }

    protected final void set(StructName key, ConstructOperation<RefStruct> translate) {
        assert (key != null) : "Expected a non-null key provided";
        assert (translate != null) : "Expected a non-null translate operation provided";
        this.nameToOperationMap.put(key, translate);
    }

    public final Procedure<RefObject> mapMetaClass(ClassName className, RefPackage sourceExtent, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap) {
        ConstructProcedure<?> mapped = this.lookupName((Name<?>)className);
        return mapped.construct(sourceExtent, targetExtent, objectsMap, (NameMapping)this);
    }

    public final Procedure<RefAssociationLink> mapMetaAssociation(AssociationName associationName, RefPackage sourceExtent, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap) {
        ConstructProcedure<?> mapped = this.lookupName((Name<?>)associationName);
        return mapped.construct(sourceExtent, targetExtent, objectsMap, (NameMapping)this);
    }

    public final Procedure<RefObject> mapMetaFieldName(FieldName fieldName, RefPackage sourceExtent, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap) {
        ConstructProcedure<?> mapped = this.lookupName((Name<?>)fieldName);
        return mapped.construct(sourceExtent, targetExtent, objectsMap, (NameMapping)this);
    }

    public final <T extends Name<?>> Name<T> getName(Name<T> source) {
        return this.constructMappedName(source);
    }

    private ConstructProcedure<?> lookupName(Name<?> name) {
        ConstructProcedure result = this.nameToMethodMap.get(name);
        if (result == null) {
            Name<?> mappedName = this.constructMappedName(name);
            result = mappedName != null ? mappedName.constructTransfromation() : name.constructNoTransfromation();
        } else {
            LOGGER.log(Level.FINE, "{0} mapped to {1}", new Object[]{name, result});
        }
        return result;
    }

    private ConstructOperation<RefStruct> lookupNameOperation(StructName name) {
        Object result = this.nameToOperationMap.get(name);
        if (result == null) {
            StructName mappedName = this.constructMappedName(name);
            result = mappedName != null ? mappedName.constructCopyOperation() : new ConstructOperation<RefStruct>(){

                public Operation<RefStruct> construct(RefPackage targetExtent, Map<RefObject, RefObject> objectsMap, NameMapping valueMapping) {
                    return new Operation<RefStruct>(){

                        public RefStruct execute(RefStruct argument) throws RuntimeException, IllegalArgumentException {
                            return null;
                        }
                    };
                }
            };
        } else {
            LOGGER.log(Level.FINE, "{0} mapped to {1}", new Object[]{name, result});
        }
        return result;
    }

    private <P extends Name<?>, T extends Name<P>> T constructMappedName(T name) {
        Name constructedParent;
        Name result = this.renaming.get(name);
        if (result == NameImpl.NO_MAP_NAME) {
            result = null;
        } else if (result == null && name.getOwner() != null && (constructedParent = this.constructMappedName(name.getOwner())) != null) {
            result = name.constructName(constructedParent, name.getName());
        }
        LOGGER.log(Level.FINE, "{0} mapped to {1}", new Object[]{name, result});
        return (T)result;
    }

    public final EnumValueName mapEnum(EnumValueName value) {
        return this.constructMappedName(value);
    }

    public final Operation<RefStruct> mapStruct(StructName structName, RefPackage targetExtent, Map<RefObject, RefObject> objectsMap) {
        return this.lookupNameOperation(structName).construct(targetExtent, objectsMap, (NameMapping)this);
    }
}

