/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Selector;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.util.Navigator;

public class SelectByQualifiedName
implements Selector<RefPackage, RefObject> {
    private final String qualifiedName;

    public SelectByQualifiedName(String qualifiedName) {
        if (qualifiedName == null || qualifiedName.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty qualified name provided ");
        }
        this.qualifiedName = qualifiedName;
    }

    public Collection<RefObject> execute(RefPackage sourceExtent) throws JmiException {
        String[] parsedQualifiedName = Name.parseQualifiedName((String)this.qualifiedName);
        ArrayList<RefObject> result = new ArrayList<RefObject>();
        List<RefObject> allObjects = Navigator.getAllObjects(sourceExtent);
        for (RefObject object : allObjects) {
            if (!this.matches((ModelElement)object, parsedQualifiedName, parsedQualifiedName.length - 1)) continue;
            result.add(object);
        }
        assert (!result.isEmpty()) : "Expected a non-empty selection found for qualified name: " + this.qualifiedName;
        return result;
    }

    private boolean matches(ModelElement object, String[] parsedQualifiedName, int i) {
        boolean result = i < 0 ? true : (object == null ? false : parsedQualifiedName[i].equals(object.getName()) && (i == 0 && object.getContainer() == null || i > 0 && this.matches((ModelElement)object.getContainer(), parsedQualifiedName, i - 1)));
        return result;
    }
}

