/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NameTokenizer
implements Iterator<String> {
    private static final int SEPARATOR_STATE = 0;
    private static final int WORD_WITH_FIRST_UPPER_STATE = 1;
    private static final int WORD_IN_LOWER_CASE_STATE = 2;
    private static final int WORD_WITH_DIGITS_STATE = 3;
    private final Iterator<String> wordsIterator;

    public NameTokenizer(String source) {
        this.wordsIterator = NameTokenizer.parse(source).iterator();
    }

    private static List<String> parse(String source) {
        int i = 0;
        ArrayList<String> result = new ArrayList<String>();
        int len = source.length();
        StringBuilder word = new StringBuilder(len);
        i = 0;
        int state = 0;
        while (i < len) {
            char current = source.charAt(i++);
            switch (state) {
                case 0: {
                    if (Character.isLetter(current)) {
                        word.append(current);
                        if (Character.isUpperCase(current)) {
                            state = 1;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    if (!Character.isDigit(current) || result.size() <= 0) break;
                    word.append(current);
                    state = 3;
                    break;
                }
                case 1: {
                    if (Character.isLetterOrDigit(current)) {
                        if (Character.isLowerCase(current)) {
                            word.append(current);
                            state = 2;
                            break;
                        }
                        if (Character.isDigit(current)) {
                            word.append(current);
                            state = 3;
                            break;
                        }
                        if (i < len && Character.isLowerCase(source.charAt(i))) {
                            result.add(word.toString());
                            word.setLength(0);
                            word.append(current);
                            break;
                        }
                        word.append(current);
                        break;
                    }
                    result.add(word.toString());
                    word.setLength(0);
                    state = 0;
                    break;
                }
                case 2: {
                    if (Character.isLowerCase(current)) {
                        word.append(current);
                        break;
                    }
                    if (Character.isDigit(current)) {
                        word.append(current);
                        state = 3;
                        break;
                    }
                    result.add(word.toString());
                    word.setLength(0);
                    if (Character.isUpperCase(current)) {
                        word.append(current);
                        state = 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (Character.isDigit(current)) {
                        word.append(current);
                        break;
                    }
                    result.add(word.toString());
                    word.setLength(0);
                    if (Character.isLetter(current)) {
                        word.append(current);
                        if (Character.isUpperCase(current)) {
                            state = 1;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    state = 0;
                }
            }
        }
        if (word.length() > 0) {
            result.add(word.toString());
        }
        return result;
    }

    @Override
    public void remove() {
        this.wordsIterator.remove();
    }

    @Override
    public boolean hasNext() {
        return this.wordsIterator.hasNext();
    }

    @Override
    public String next() {
        return this.wordsIterator.next();
    }
}

