/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Classifier;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;
import javax.jmi.reflect.InvalidNameException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import net.mdatools.modelant.core.api.Operation;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.operation.element.PrintModelElement;

public class Navigator {
    private static final PrintModelElement PRINT_MODEL_ELEMENT = new PrintModelElement();
    public static final String OBJECT_PATH_SEPARATORS = "\\.";
    public static final String NAME_MOFID = "MOFID";
    public static final String NAME_METAOBJECT = "METAOBJECT";
    public static final String NAME_METACLASSNAME = "METACLASSNAME";
    public static final String NAME_OUTER_MOST_PACKAGE = "OPACKAGE";
    public static final String NAME_IMMEDIATE_PACKAGE = "IPACKAGE";

    public static List<? extends Object> collectValues(RefFeatured startFrom, String path, boolean reportExceptions) throws JmiException {
        ArrayList<Object> result = new ArrayList<Object>();
        String[] parsedPath = path.split(OBJECT_PATH_SEPARATORS);
        Navigator.collectAllValues(startFrom, parsedPath, 0, result, reportExceptions);
        return result;
    }

    private static void collectAllValues(Object startFrom, String[] parsedPath, int startIndex, List<Object> output, boolean reportExceptions) {
        if (startIndex >= parsedPath.length) {
            if (startFrom != null) {
                output.add(startFrom);
            }
        } else {
            Object result;
            String itemName = parsedPath[startIndex];
            try {
                result = Navigator.getReflectiveValue(startFrom, itemName);
            }
            catch (Exception ex) {
                if (reportExceptions) {
                    throw new IllegalArgumentException("Navigating down the path: " + Arrays.asList(Arrays.copyOf(parsedPath, startIndex - 1)) + " reached " + PRINT_MODEL_ELEMENT.execute(startFrom) + " where could not find " + itemName, ex);
                }
                result = null;
            }
            if (result instanceof Collection) {
                Iterator associatedIterator = ((Collection)result).iterator();
                while (associatedIterator.hasNext()) {
                    Navigator.collectAllValues(associatedIterator.next(), parsedPath, startIndex + 1, output, reportExceptions);
                }
            } else if (result != null) {
                Navigator.collectAllValues(result, parsedPath, startIndex + 1, output, reportExceptions);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getReflectiveValue(Object startFrom, String itemName) throws InvalidNameException {
        if (NAME_MOFID.equalsIgnoreCase(itemName)) {
            if (!(startFrom instanceof RefBaseObject)) throw new InvalidNameException(itemName, "In order to retrieve the MOF ID of the processed object (MOFID) expected an instance of RefBaseObject  instead of " + startFrom);
            return ((RefBaseObject)startFrom).refMofId();
        }
        if (NAME_METAOBJECT.equalsIgnoreCase(itemName)) {
            if (!(startFrom instanceof RefBaseObject)) throw new InvalidNameException(itemName, "In order to retrieve the meta-object of the processed object (METAOBJECT) expected an instance of RefBaseObject  instead of " + startFrom);
            return ((RefBaseObject)startFrom).refMetaObject();
        }
        if (NAME_METACLASSNAME.equalsIgnoreCase(itemName)) {
            if (!(startFrom instanceof RefObject)) throw new InvalidNameException(itemName, "In order to retrieve the metaclass of the processed object (METACLASSNAME) expected an instance of RefObject  instead of " + startFrom);
            return Navigator.constructQualifiedName((ModelElement)((RefObject)startFrom).refClass().refMetaObject());
        }
        if (NAME_OUTER_MOST_PACKAGE.equalsIgnoreCase(itemName)) {
            if (!(startFrom instanceof RefBaseObject)) throw new InvalidNameException(itemName, "In order to retrieve the outer-most package in the meta-model the processed object is inOPACKAGE expected an instance of RefBaseObject  instead of " + startFrom);
            return ((RefBaseObject)startFrom).refOutermostPackage();
        }
        if (NAME_IMMEDIATE_PACKAGE.equalsIgnoreCase(itemName)) {
            if (!(startFrom instanceof RefBaseObject)) throw new InvalidNameException(itemName, "In order to retrieve the immediate package in the meta-model the processed object is in (IPACKAGE) expected an instance of RefBaseObject  instead of " + startFrom);
            return ((RefBaseObject)startFrom).refImmediatePackage();
        }
        if (startFrom instanceof RefFeatured) {
            try {
                return ((RefFeatured)startFrom).refGetValue(itemName);
            }
            catch (JmiException ex) {
                throw new IllegalArgumentException(" Retrieving the value of field '" + itemName + "' caused ", ex);
            }
        }
        if (!(startFrom instanceof RefStruct)) throw new InvalidNameException(itemName, "Expected a RefFeatured or RefStruct instance instead of " + startFrom + " to get its " + itemName);
        try {
            return ((RefStruct)startFrom).refGetValue(itemName);
        }
        catch (JmiException ex) {
            throw new IllegalArgumentException(" Retrieving the value of field '" + itemName + "' caused ", ex);
        }
    }

    public static List<RefObject> getAllObjects(RefPackage sourceExtent) {
        final ArrayList<RefObject> result = new ArrayList<RefObject>();
        Navigator.process(sourceExtent, new ProcessPackage(){

            public RefPackage execute(RefPackage refPackage) throws RuntimeException, IllegalArgumentException {
                for (RefClass metaClass : refPackage.refAllClasses()) {
                    result.addAll(metaClass.refAllOfClass());
                }
                return null;
            }
        });
        return result;
    }

    public static List<RefAssociation> getAllAssociations(RefPackage sourceExtent) {
        final ArrayList<RefAssociation> result = new ArrayList<RefAssociation>();
        Navigator.process(sourceExtent, new ProcessPackage(){

            public RefPackage execute(RefPackage refPackage) throws RuntimeException, IllegalArgumentException {
                result.addAll(refPackage.refAllAssociations());
                return null;
            }
        });
        return result;
    }

    public static List<RefClass> getAllClasses(RefPackage sourceExtent) {
        final ArrayList<RefClass> result = new ArrayList<RefClass>();
        Navigator.process(sourceExtent, new ProcessPackage(){

            public RefPackage execute(RefPackage refPackage) throws RuntimeException, IllegalArgumentException {
                result.addAll(refPackage.refAllClasses());
                return null;
            }
        });
        return result;
    }

    private static void process(RefPackage thisPackage, ProcessPackage processPackage) {
        processPackage.execute(thisPackage);
        for (RefPackage nested : thisPackage.refAllPackages()) {
            Navigator.process(nested, processPackage);
        }
    }

    public static RefPackage getMetaPackage(RefPackage rootPackage, String metaPackageName) throws JmiException {
        assert (rootPackage != null) : "Expected a non-null package";
        RefPackage result = rootPackage;
        String[] parsedPath = Name.parseQualifiedName((String)metaPackageName);
        for (int i = 0; i < parsedPath.length; ++i) {
            String itemName = parsedPath[i];
            try {
                result = result.refPackage(itemName);
                continue;
            }
            catch (JmiException ex) {
                throw new IllegalArgumentException("Looking up the package " + metaPackageName + " down the path: " + Arrays.asList(Arrays.copyOf(parsedPath, i)) + " reached " + PRINT_MODEL_ELEMENT.execute(result) + " for which retrieving the nested package '" + itemName + "' caused ", ex);
            }
        }
        return result;
    }

    public static RefClass getMetaClass(RefPackage rootPackage, String metaClassName) throws JmiException {
        RefClass result = null;
        assert (rootPackage != null) : "Expected a non-null package";
        String[] parsedPath = Name.parseQualifiedName((String)metaClassName);
        int i = 0;
        while (i < parsedPath.length) {
            String itemName = parsedPath[i++];
            try {
                if (i < parsedPath.length) {
                    rootPackage = rootPackage.refPackage(itemName);
                    continue;
                }
                result = rootPackage.refClass(itemName);
            }
            catch (JmiException ex) {
                throw new IllegalArgumentException("Looking up the package " + metaClassName + " down the path: " + Arrays.asList(Arrays.copyOf(parsedPath, i - 1)) + " reached " + PRINT_MODEL_ELEMENT.execute(result) + " for which retrieving the nested package '" + itemName + "' caused ", ex);
            }
        }
        return result;
    }

    public static String getMetaClassName(RefObject element) throws JmiException {
        assert (element != null) : "Expected a non-null model element";
        return Navigator.constructQualifiedName((ModelElement)element.refMetaObject());
    }

    private static String constructQualifiedName(ModelElement metaObject) {
        StringBuilder result = new StringBuilder(256);
        Navigator.insertQualifiedName(metaObject, result);
        return result.toString();
    }

    private static void insertQualifiedName(ModelElement metaObject, StringBuilder result) {
        Namespace next = metaObject.getContainer();
        if (next != null) {
            Navigator.insertQualifiedName((ModelElement)next, result);
            result.append("::");
        }
        result.append(metaObject.getName());
    }

    public static Collection<Classifier> getAllSuperMetaObejcts(Classifier mofMetaObject) {
        HashSet<Classifier> result = new HashSet<Classifier>(11);
        ArrayList<Classifier> toProcess = new ArrayList<Classifier>();
        toProcess.add(mofMetaObject);
        while (!toProcess.isEmpty()) {
            mofMetaObject = (Classifier)toProcess.remove(0);
            if (!result.add(mofMetaObject)) continue;
            toProcess.addAll(mofMetaObject.allSupertypes());
        }
        return result;
    }

    private static interface ProcessPackage
    extends Operation<RefPackage> {
    }
}

