/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.util.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompositeMap<K, V>
implements Map<K, V> {
    private final Map<K, V> wrapped;
    private final Map<K, V> local = new HashMap();

    public CompositeMap(Map<K, V> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void clear() {
        this.wrapped.clear();
        this.local.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.local.containsKey(key) || this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.local.containsValue(value) || this.wrapped.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V result = this.local.containsKey(key) ? this.local.get(key) : this.wrapped.get(key);
        return result;
    }

    @Override
    public Set entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        result.addAll(this.wrapped.entrySet());
        result.addAll(this.local.entrySet());
        return result;
    }

    @Override
    public Set keySet() {
        HashSet<K> result = new HashSet<K>();
        result.addAll(this.wrapped.keySet());
        result.addAll(this.local.keySet());
        return result;
    }

    @Override
    public Collection values() {
        HashSet<V> result = new HashSet<V>();
        result.addAll(this.wrapped.values());
        result.addAll(this.local.values());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.local.isEmpty() && this.wrapped.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        return this.local.put(key, value);
    }

    @Override
    public void putAll(Map m) {
        this.local.putAll(m);
    }

    @Override
    public V remove(Object key) {
        V result = this.local.containsKey(key) ? this.local.remove(key) : this.wrapped.remove(key);
        return result;
    }

    @Override
    public int size() {
        return this.local.size() + this.wrapped.size();
    }

    public String toString() {
        HashMap local = new HashMap(this);
        return ((Object)local).toString();
    }
}

