/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.util.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapToCollection<K, V>
implements Serializable {
    private final Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    public final void clear() {
        this.map.clear();
    }

    public final boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public Collection<V> get(K key) {
        Collection<V> result = this.map.get(key);
        return result;
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Set<K> keySet() {
        return this.map.keySet();
    }

    public final Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    public final Collection<V> put(K key, V value) {
        Collection<V> result = this.get(key);
        if (result == null) {
            result = this.createValuesCollection();
            this.map.put(key, result);
        }
        result.add(value);
        return result;
    }

    public final Collection<V> put(K key, Collection<V> value) {
        Collection<V> result = this.get(key);
        if (result == null) {
            result = this.createValuesCollection();
            result.addAll(value);
            this.map.put(key, result);
        }
        return result;
    }

    public final void putAll(MapToCollection<K, V> t) {
        for (Map.Entry<K, Collection<V>> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public final Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    public final boolean remove(K key, V value) {
        boolean result;
        Collection<V> values = this.get(key);
        if (values != null) {
            result = values.remove(value);
            if (values.isEmpty()) {
                this.map.remove(key);
            }
        } else {
            result = false;
        }
        return result;
    }

    public final Collection<V> values() {
        Collection<V> result = this.createValuesCollection();
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            Collection<V> values = entry.getValue();
            if (values == null) continue;
            result.addAll(values);
        }
        return result;
    }

    protected abstract Collection<V> createValuesCollection();

    public String toString() {
        StringBuilder result = new StringBuilder(2048);
        result.append(" {");
        for (Map.Entry<K, Collection<V>> entry : this.map.entrySet()) {
            result.append("\r\n").append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        if (!this.map.isEmpty()) {
            result.append("\r\n");
        }
        result.append("}");
        return result.toString();
    }

    public final Map<K, Collection<V>> toMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

