/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.core.wrap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mdatools.modelant.core.api.wrap.Wrapper;
import net.mdatools.modelant.core.api.wrap.WrapperFactory;

public abstract class BaseWrapperFactory
implements WrapperFactory {
    private final Map<Object, Wrapper<? extends Object>> wrappedToWrapperMap = new IdentityHashMap<Object, Wrapper<? extends Object>>(1023);

    public final <A> Wrapper<A> wrap(A toWrap) throws IllegalArgumentException {
        Object result;
        if (toWrap == null) {
            result = null;
        } else {
            result = this.wrappedToWrapperMap.get(toWrap);
            if (result == null) {
                result = this.constructWrapper(toWrap);
                this.wrappedToWrapperMap.put(toWrap, (Wrapper<? extends Object>)result);
            }
        }
        return result;
    }

    public final <A> List<Wrapper<A>> wrap(Collection<A> toWrap) throws IllegalArgumentException {
        ArrayList<Wrapper<A>> result;
        if (toWrap == null) {
            result = null;
        } else {
            result = new ArrayList<Wrapper<A>>(toWrap.size());
            for (A obj : toWrap) {
                result.add(this.wrap(obj));
            }
        }
        return result;
    }

    public final void destroy() {
        this.wrappedToWrapperMap.clear();
    }

    public final <A> void bind(Wrapper<A> wrapper) throws IllegalArgumentException {
        Wrapper<A> existing = this.wrappedToWrapperMap.put(wrapper.getWrapped(), wrapper);
        if (existing != null) {
            throw new IllegalArgumentException("Registering a wrapper for an object that was already wrapped");
        }
    }

    private <A> Wrapper<A> constructWrapper(A toWrap) throws IllegalArgumentException {
        Wrapper result;
        Class resultClass = this.getMappedClass(toWrap);
        try {
            Constructor constructor = resultClass.getConstructor(Object.class, WrapperFactory.class);
            result = (Wrapper)constructor.newInstance(toWrap, this);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        return result;
    }

    private <A> Class getMappedClass(A toWrap) throws IllegalArgumentException {
        Class<? extends Wrapper> result;
        if (toWrap instanceof Wrapper) {
            result = this.getMappedClass(((Wrapper)toWrap).getWrapped());
        } else {
            Class<?> sourceClass = toWrap.getClass();
            result = this.getMappedClass(sourceClass);
            if (result == null && sourceClass.getInterfaces().length > 0 && (result = this.getMappedClass(sourceClass.getInterfaces()[0])) == null) {
                throw new IllegalArgumentException("Could not identify the wrapper class for: " + toWrap);
            }
        }
        return result;
    }

    protected abstract Class<? extends Wrapper> getMappedClass(Class<?> var1);
}

