/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.maven.plugin.compare;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.diff.Export;
import net.mdatools.modelant.core.api.diff.ModelComparisonResult;
import net.mdatools.modelant.core.api.match.ConsideredEqual;
import net.mdatools.modelant.repository.api.ModelFactory;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.repository.api.ModelRepositoryFactory;
import net.mdatools.modelant.uml13.metamodel.CompareUml13Models;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compare-uml13-models", defaultPhase=LifecyclePhase.COMPILE)
@Execute(phase=LifecyclePhase.COMPILE)
public class CompareModelsMojo
extends AbstractMojo {
    @Parameter(property="project.build.sourceDirectory", required=true)
    private File sourceModel;
    @Parameter(required=true)
    private File targetModel;
    @Parameter(property="project.build.directory", required=true)
    private File workDirectory;
    @Parameter
    private List<ConsideredEqual> equals;
    @Parameter
    private Export export = Export.DEFAULT;

    public void execute() throws MojoExecutionException {
        ModelRepository repository = ModelRepositoryFactory.construct((File)this.workDirectory);
        try {
            ModelFactory metamodelFactory = repository.loadMetamodel("UML13");
            RefPackage sourceExtent = metamodelFactory.instantiate("SOURCE");
            RefPackage targetExtent = metamodelFactory.instantiate("TARGET");
            repository.readIntoExtent(sourceExtent, this.sourceModel);
            repository.readIntoExtent(targetExtent, this.targetModel);
            List<ConsideredEqual> bindings = this.equals == null ? new ArrayList<ConsideredEqual>() : this.equals;
            CompareUml13Models compare = new CompareUml13Models(bindings, sourceExtent);
            ModelComparisonResult result = compare.execute(targetExtent);
            this.export.export(result);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("The target failed with:", ex);
        }
        finally {
            repository.shutdown();
        }
    }
}

