/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.maven.plugin.reverse;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.repository.api.ModelRepositoryFactory;
import net.mdatools.modelant.uml13.reverse.ReverseDatabaseOperation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="database-to-uml13", defaultPhase=LifecyclePhase.COMPILE)
@Execute(phase=LifecyclePhase.COMPILE)
public class ReverseEngineerDatabaseMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String url;
    @Parameter(required=true)
    private String user;
    @Parameter(required=true)
    private String password;
    @Parameter(required=true)
    private String driver;
    @Parameter(required=true)
    private String[] schema;
    @Parameter(required=true)
    private File outputFile;
    @Parameter(property="project.build.directory", required=true)
    private File workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            ModelRepository modelRepository = ModelRepositoryFactory.construct((File)this.workDir);
            try {
                RefPackage extent;
                Class.forName(this.driver);
                try (Connection connection = DriverManager.getConnection(this.url, this.user, this.password);){
                    ReverseDatabaseOperation operation = new ReverseDatabaseOperation(modelRepository, this.schema);
                    extent = (RefPackage)operation.execute((Object)connection);
                }
                modelRepository.writeExtent(extent, this.outputFile, "1.2");
            }
            finally {
                modelRepository.shutdown();
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Connecting database:" + this.url + " with user:" + this.user + " and password:" + this.password + " caused exception:", (Exception)e);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Driver class " + this.driver + " not found", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }
}

