/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.maven.plugin.reverse;

import java.io.File;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.repository.api.ModelRepositoryFactory;
import net.mdatools.modelant.uml13.reverse.ReverseXsdOperation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="xsd-to-uml13", defaultPhase=LifecyclePhase.COMPILE)
@Execute(phase=LifecyclePhase.COMPILE)
public class ReverseEngineerXsdMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File schemaFile;
    @Parameter(required=true)
    private File outputFile;
    @Parameter(property="project.build.directory", required=true)
    private File workDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException {
        try {
            ModelRepository modelRepository = ModelRepositoryFactory.construct((File)this.workDir);
            try {
                ReverseXsdOperation reverse = new ReverseXsdOperation(modelRepository);
                RefPackage extent = (RefPackage)reverse.execute((Object)this.schemaFile);
                this.getLog().info((CharSequence)("Writing " + this.outputFile));
                modelRepository.writeExtent(extent, this.outputFile, "1.2");
            }
            finally {
                modelRepository.shutdown();
            }
        }
        catch (Exception ex) {
            throw new MojoFailureException("No model exported", (Throwable)ex);
        }
    }
}

