/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.reverse;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.repository.api.ModelFactory;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.uml13.reverse.Uml13ModelFactory;
import org.omg.uml13.foundation.core.Attribute;
import org.omg.uml13.foundation.core.Classifier;
import org.omg.uml13.foundation.core.DataType;
import org.omg.uml13.foundation.core.ModelElement;
import org.omg.uml13.foundation.core.UmlClass;
import org.omg.uml13.foundation.datatypes.Expression;
import org.omg.uml13.foundation.datatypes.VisibilityKind;
import org.omg.uml13.foundation.datatypes.VisibilityKindEnum;

public class ReverseDatabaseOperation
implements Function<Connection, RefPackage> {
    private static final Logger LOGGER = Logger.getLogger(ReverseDatabaseOperation.class.getName());
    private static final String LEGAL_TABLE_NAME_REGEX = "^[a-z$#A-Z0-9_]+$";
    private static final String JDBC_COLUMN_DESCRIPTION_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String JDBC_COLUMN_DESCRIPTION_COLUMN_SIZE = "COLUMN_SIZE";
    private static final String JDBC_COLUMN_DESCRIPTION_TYPE_NAME = "TYPE_NAME";
    private static final String JDBC_COLUMN_DESCRIPTION_NAME = "COLUMN_NAME";
    private static final String JDBC_COLUMN_DESCRIPTION_REMARKS = "REMARKS";
    private static final String JDBC_COLUMN_DESCRIPTION_COLUMN_DEFAULT = "COLUMN_DEF";
    private static final String JDBC_TABLE_DESCRIPTION_TABLE_NAME = "TABLE_NAME";
    private static final String JDBC_TABLE_DESCRIPTION_REMARKS = "REMARKS";
    private static final String JDBC_PK_DESCRIPTION_COLUMN_NAME = "COLUMN_NAME";
    private static final String JDBC_PK_DESCRIPTION_SEQENCE = "KEY_SEQ";
    private static final String JDBC_RELATION_DESCRIPTION_PK_TABLE_NAME = "PKTABLE_NAME";
    private static final String JDBC_RELATION_DESCRIPTION_FK_FIELD = "FKCOLUMN_NAME";
    private static final String JDBC_RELATION_DESCRIPTION_DELETE_RULE = "DELETE_RULE";
    private static final String[] TABLE_TYPES_TO_REVERSE = new String[]{"TABLE", "VIEW", "SYSTEM TABLE", "ALIAS", "SYNONYM"};
    private final ModelRepository modelRepository;
    private final String[] schemes;
    private Uml13ModelFactory factory;

    public ReverseDatabaseOperation(ModelRepository modelRepository, String ... schemes) {
        this.modelRepository = modelRepository;
        this.schemes = schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<UmlClass> processTables(DatabaseMetaData metadata, String schema) throws SQLException {
        ArrayList<UmlClass> result = new ArrayList<UmlClass>();
        try (ResultSet tableDescriptions = metadata.getTables(null, schema.toUpperCase(), "%", TABLE_TYPES_TO_REVERSE);){
            while (tableDescriptions.next()) {
                String tableName = tableDescriptions.getString(JDBC_TABLE_DESCRIPTION_TABLE_NAME);
                LOGGER.log(Level.INFO, "Table: {0}", tableName);
                if (this.isValidTableName(tableName)) {
                    UmlClass umlClass = this.factory.constructClass(tableName);
                    result.add(umlClass);
                    String remarks = tableDescriptions.getString("REMARKS");
                    this.factory.constructTagDocumentation((ModelElement)umlClass, remarks);
                    this.factory.constructTagPersistent(umlClass);
                    this.defineAttributes(metadata, umlClass, schema, tableName);
                } else {
                    LOGGER.log(Level.INFO, "  skipped");
                }
                LOGGER.log(Level.INFO, "");
            }
        }
        return result;
    }

    private boolean isValidTableName(String tableName) {
        return tableName.matches(LEGAL_TABLE_NAME_REGEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRelationships(List<UmlClass> tables, DatabaseMetaData metadata, String schema) throws SQLException {
        for (UmlClass thisClass : tables) {
            String tableName = thisClass.getName();
            LOGGER.log(Level.INFO, "Relations of: {0}", tableName);
            try (ResultSet relationDescriptions = metadata.getImportedKeys(null, schema, tableName);){
                while (relationDescriptions.next()) {
                    String otherTable = relationDescriptions.getString(JDBC_RELATION_DESCRIPTION_PK_TABLE_NAME);
                    String thisField = relationDescriptions.getString(JDBC_RELATION_DESCRIPTION_FK_FIELD);
                    try {
                        UmlClass otherClass = this.findClass(otherTable);
                        boolean isComposite = relationDescriptions.getShort(JDBC_RELATION_DESCRIPTION_DELETE_RULE) == 0;
                        this.factory.constructAssociation((Classifier)otherClass, thisField, 1, isComposite, true, (Classifier)thisClass, "", -1, thisClass.getNamespace(), "");
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.SEVERE, ex.getMessage());
                    }
                }
            }
        }
    }

    private UmlClass findClass(String className) throws IllegalArgumentException {
        return (UmlClass)this.factory.locateModelElement(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineAttributes(DatabaseMetaData metadata, UmlClass umlClass, String schema, String tableName) throws SQLException {
        Map<String, Short> primaryKeys = this.definePrimaryKey(metadata, schema, tableName);
        try (ResultSet attributesRS = metadata.getColumns(null, schema, tableName, "%");){
            while (attributesRS.next()) {
                Short sequence;
                String columnName = attributesRS.getString("COLUMN_NAME");
                Attribute attribute = this.factory.constructAttribute(columnName);
                attribute.setOwner((Classifier)umlClass);
                attribute.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
                DataType attributeType = this.factory.constructDataType(attributesRS.getString(JDBC_COLUMN_DESCRIPTION_TYPE_NAME));
                attribute.setType((Classifier)attributeType);
                int size = attributesRS.getInt(JDBC_COLUMN_DESCRIPTION_COLUMN_SIZE);
                int precision = attributesRS.getInt(JDBC_COLUMN_DESCRIPTION_DECIMAL_DIGITS);
                this.factory.constructTagSize((ModelElement)attribute, size);
                if (precision > 0) {
                    this.factory.constructTagFieldPrecision((ModelElement)attribute, precision);
                }
                String remark = attributesRS.getString("REMARKS");
                this.factory.constructTagDocumentation((ModelElement)attribute, remark);
                String defaultValue = attributesRS.getString(JDBC_COLUMN_DESCRIPTION_COLUMN_DEFAULT);
                if (defaultValue != null && !defaultValue.equals("")) {
                    Expression expression = this.factory.constructExpression(defaultValue);
                    attribute.setInitialValue(expression);
                }
                if ((sequence = primaryKeys.get(columnName)) == null) continue;
                this.factory.constructTagPrimaryKey(attribute, sequence.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Short> definePrimaryKey(DatabaseMetaData metadata, String schema, String tableName) throws SQLException {
        HashMap<String, Short> result = new HashMap<String, Short>(11);
        try (ResultSet primaryKeys = metadata.getPrimaryKeys(null, schema, tableName);){
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString("COLUMN_NAME");
                short sequence = primaryKeys.getShort(JDBC_PK_DESCRIPTION_SEQENCE);
                result.put(columnName, new Short(sequence));
            }
        }
        return result;
    }

    protected void dumpResultSet(ResultSet resultSet) throws SQLException {
        int i;
        ResultSetMetaData resultSetMeta = resultSet.getMetaData();
        LOGGER.log(Level.INFO, "Column names:");
        StringBuilder line = new StringBuilder(256);
        for (i = 1; i <= resultSetMeta.getColumnCount(); ++i) {
            if (i > 1) {
                line.append(", ");
            }
            line.append(resultSetMeta.getColumnLabel(i));
        }
        LOGGER.log(Level.INFO, line.toString());
        LOGGER.log(Level.INFO, line.toString().replaceAll(".", "-"));
        while (resultSet.next()) {
            line = new StringBuilder(256);
            for (i = 1; i <= resultSetMeta.getColumnCount(); ++i) {
                if (i > 1) {
                    line.append(", ");
                }
                line.append(resultSet.getObject(i));
            }
            LOGGER.log(Level.INFO, line.toString());
        }
        resultSet.close();
    }

    public RefPackage execute(Connection connection) throws IllegalArgumentException {
        ModelFactory modelFactory = this.modelRepository.loadMetamodel("UML13");
        RefPackage result = modelFactory.instantiate("model");
        this.factory = new Uml13ModelFactory(result);
        this.factory.setModelName(this.schemes[0]);
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            for (String schema : this.schemes) {
                List<UmlClass> tables = this.processTables(metadata, schema);
                this.processRelationships(tables, metadata, schema);
            }
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException(ex);
        }
        return result;
    }
}

