/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.reverse;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.repository.api.ModelFactory;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.repository.api.ModelRepositoryFactory;
import net.mdatools.modelant.uml13.reverse.Uml13ModelFactory;
import org.omg.uml13.foundation.core.Attribute;
import org.omg.uml13.foundation.core.BehavioralFeature;
import org.omg.uml13.foundation.core.Classifier;
import org.omg.uml13.foundation.core.Dependency;
import org.omg.uml13.foundation.core.Interface;
import org.omg.uml13.foundation.core.ModelElement;
import org.omg.uml13.foundation.core.Namespace;
import org.omg.uml13.foundation.core.Operation;
import org.omg.uml13.foundation.core.Parameter;
import org.omg.uml13.foundation.core.UmlClass;
import org.omg.uml13.foundation.datatypes.CallConcurrencyKind;
import org.omg.uml13.foundation.datatypes.CallConcurrencyKindEnum;
import org.omg.uml13.foundation.datatypes.ChangeableKind;
import org.omg.uml13.foundation.datatypes.ChangeableKindEnum;
import org.omg.uml13.foundation.datatypes.Expression;
import org.omg.uml13.foundation.datatypes.ParameterDirectionKind;
import org.omg.uml13.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml13.foundation.datatypes.ScopeKind;
import org.omg.uml13.foundation.datatypes.ScopeKindEnum;
import org.omg.uml13.foundation.datatypes.VisibilityKind;
import org.omg.uml13.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml13.modelmanagement.UmlPackage;

public class ReverseEngineerJavaDoclet
extends Doclet {
    public static final String PARAMETER_TARGET_FILE = "target";
    public static final String PARAMETER_WORK_DIR = "workDir";
    public static final String PARAMETER_MODEL = "model";
    private static final String RETURN_PARAMETER_NAME = "return";
    private static final String JAVADOC_RETURN_TAG_NAME = "@return";
    private final File outputModelFile;
    private final RefPackage extent;
    private final ModelRepository repository;
    private final ModelFactory modelFactory;
    private final Uml13ModelFactory factory;

    private ReverseEngineerJavaDoclet() {
        File workDir = new File(System.getProperty(PARAMETER_WORK_DIR, System.getProperty("java.io.tmpdir")));
        String modelName = System.getProperty(PARAMETER_MODEL, PARAMETER_MODEL);
        String modelFile = System.getProperty(PARAMETER_TARGET_FILE, "model.xml");
        this.outputModelFile = new File(modelFile);
        this.repository = ModelRepositoryFactory.construct((File)workDir);
        this.modelFactory = this.repository.loadMetamodel("UML13");
        this.extent = this.modelFactory.instantiate();
        this.factory = new Uml13ModelFactory(this.extent);
        this.factory.setModelName(modelName);
    }

    public static boolean start(RootDoc root) {
        try {
            ReverseEngineerJavaDoclet doclet = new ReverseEngineerJavaDoclet();
            try {
                doclet.generate(root);
                doclet.export();
            }
            finally {
                doclet.shutDown();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    public static int optionLength(String option) {
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    private void export() throws FileNotFoundException, IOException {
        System.out.println("Writing " + this.outputModelFile + "...");
        this.modelFactory.writeExtent(this.extent, this.outputModelFile);
    }

    private void shutDown() {
        this.repository.shutdown();
    }

    private void generate(RootDoc root) {
        int i;
        ClassDoc[] classes = root.classes();
        for (i = 0; i < classes.length; ++i) {
            this.generateType(classes[i]);
        }
        for (i = 0; i < classes.length; ++i) {
            ClassDoc classDoc = classes[i];
            this.fillInType(classDoc);
        }
    }

    private void fillInType(ClassDoc classDoc) {
        int j;
        Classifier umlClassifier = (Classifier)this.factory.locateModelElement(classDoc.qualifiedName());
        FieldDoc[] fields = classDoc.fields(false);
        for (j = 0; j < fields.length; ++j) {
            Attribute attribute = this.createAttribute(fields[j]);
            attribute.setOwner(umlClassifier);
            if (!classDoc.isInterface()) continue;
            attribute.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
            attribute.setOwnerScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
            attribute.setChangeability((ChangeableKind)ChangeableKindEnum.CK_FROZEN);
        }
        ConstructorDoc[] constructors = classDoc.constructors(false);
        for (j = 0; j < constructors.length; ++j) {
            Operation constructor = this.createConstructor(constructors[j], umlClassifier);
            constructor.setOwner(umlClassifier);
        }
        MethodDoc[] methods = classDoc.methods(false);
        for (j = 0; j < methods.length; ++j) {
            Operation method = this.createMethod(methods[j]);
            method.setOwner(umlClassifier);
            if (!classDoc.isInterface()) continue;
            method.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
            method.setAbstract(true);
        }
    }

    private Classifier generateType(ClassDoc classDoc) {
        Classifier result;
        try {
            result = (Classifier)this.factory.locateModelElement(classDoc.qualifiedName());
        }
        catch (IllegalArgumentException ex) {
            if (classDoc.isIncluded()) {
                if (classDoc.isClass()) {
                    result = this.gerenateClass(classDoc);
                } else if (classDoc.fields().length == 0) {
                    result = this.gerenateInterface(classDoc);
                } else {
                    result = this.gerenateClass(classDoc);
                    this.factory.constructStereotype((ModelElement)result, "Interface");
                }
            }
            result = this.factory.constructDataType(classDoc.qualifiedName());
        }
        return result;
    }

    private Name parseQualifiedName(ClassDoc classDoc) {
        ClassNameImpl result = new ClassNameImpl(classDoc.qualifiedName());
        return result;
    }

    private Classifier gerenateInterface(ClassDoc classDoc) {
        UmlPackage umlPackage = this.createPackage(classDoc.containingPackage());
        Classifier containingClassifier = null;
        String interfaceName = classDoc.name();
        ClassDoc containingClassifierDoc = classDoc.containingClass();
        if (containingClassifierDoc != null) {
            containingClassifier = this.generateType(containingClassifierDoc);
            interfaceName = interfaceName.substring(containingClassifierDoc.name().length() + 1);
        }
        Interface result = this.factory.constructInterface((Namespace)umlPackage, interfaceName);
        if (containingClassifier != null) {
            result.setNamespace((Namespace)containingClassifier);
        }
        if (classDoc.isPublic()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        } else if (classDoc.isPrivate()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PRIVATE);
        } else if (classDoc.isProtected()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PROTECTED);
        }
        result.setLeaf(classDoc.isFinal());
        result.setAbstract(classDoc.isAbstract());
        this.factory.constructTagDocumentation((ModelElement)result, classDoc.commentText());
        this.createSuperInetrfaces(classDoc, (Classifier)result);
        return result;
    }

    private Classifier gerenateClass(ClassDoc classDoc) {
        Classifier containingClassifier = null;
        String className = classDoc.name();
        UmlPackage umlPackage = this.createPackage(classDoc.containingPackage());
        ClassDoc containingClassifierDoc = classDoc.containingClass();
        if (containingClassifierDoc != null) {
            containingClassifier = this.generateType(containingClassifierDoc);
            className = className.substring(containingClassifierDoc.name().length() + 1);
        }
        UmlClass result = this.factory.constructClass((Namespace)umlPackage, className);
        if (containingClassifier != null) {
            result.setNamespace((Namespace)containingClassifier);
        }
        if (classDoc.isPublic()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        } else if (classDoc.isPrivate()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PRIVATE);
        } else if (classDoc.isProtected()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PROTECTED);
        }
        result.setLeaf(classDoc.isFinal());
        result.setAbstract(classDoc.isAbstract());
        this.factory.constructTagDocumentation((ModelElement)result, classDoc.commentText());
        ClassDoc superclassDoc = classDoc.superclass();
        if (superclassDoc != null) {
            Classifier superClass = this.generateType(superclassDoc);
            this.factory.constructGeneralization((Classifier)result, superClass);
        }
        this.createSuperInetrfaces(classDoc, (Classifier)result);
        return result;
    }

    private void createSuperInetrfaces(ClassDoc classDoc, Classifier umlClass) {
        ClassDoc[] interfacesDoc = classDoc.interfaces();
        for (int i = 0; i < interfacesDoc.length; ++i) {
            Classifier superClass = this.generateType(interfacesDoc[i]);
            this.factory.constructGeneralization(umlClass, superClass);
        }
    }

    private UmlPackage createPackage(PackageDoc packageDoc) {
        UmlPackage result = this.factory.constructPackage(packageDoc.name());
        this.factory.constructTagDocumentation((ModelElement)result, packageDoc.commentText());
        return result;
    }

    private Operation createConstructor(ConstructorDoc doc, Classifier thisClass) {
        String parameterComment;
        Parameter parameter;
        int i;
        Operation result = this.factory.constructOperation(doc.name());
        result.setSpecification(false);
        result.setQuery(false);
        this.factory.constructTagDocumentation((ModelElement)result, doc.commentText());
        if (doc.isPublic()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        } else if (doc.isPrivate()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PRIVATE);
        } else if (doc.isProtected()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PROTECTED);
        }
        if (doc.isStatic()) {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
        } else {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        }
        result.setAbstract(false);
        result.setLeaf(false);
        if (doc.isSynchronized()) {
            result.setConcurrency((CallConcurrencyKind)CallConcurrencyKindEnum.CCK_SEQUENTIAL);
        } else {
            result.setConcurrency((CallConcurrencyKind)CallConcurrencyKindEnum.CCK_CONCURRENT);
        }
        com.sun.javadoc.Parameter[] parameters = doc.parameters();
        ParamTag[] parameterTags = doc.paramTags();
        for (i = 0; i < parameters.length; ++i) {
            parameter = this.createParameter(parameters[i].name(), parameters[i].type(), ParameterDirectionKindEnum.PDK_INOUT);
            parameter.setBehavioralFeature((BehavioralFeature)result);
            parameterComment = this.findComment(JAVADOC_RETURN_TAG_NAME, doc.tags());
            if (parameterComment == null) continue;
            this.factory.constructTagDocumentation((ModelElement)parameter, parameterComment);
        }
        parameter = this.factory.constructParameter(RETURN_PARAMETER_NAME);
        parameter.setType(thisClass);
        parameter.setKind((ParameterDirectionKind)ParameterDirectionKindEnum.PDK_RETURN);
        parameter.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        parameter.setBehavioralFeature((BehavioralFeature)result);
        parameterComment = this.findComment(JAVADOC_RETURN_TAG_NAME, parameterTags);
        if (parameterComment != null) {
            this.factory.constructTagDocumentation((ModelElement)parameter, parameterComment);
        }
        ClassDoc[] exceptions = doc.thrownExceptions();
        for (i = 0; i < exceptions.length; ++i) {
            Classifier thrownException = this.factory.constructException(exceptions[i].qualifiedName());
            Dependency dependency = this.factory.constructDependency((ModelElement)result, (ModelElement)thrownException, "");
            this.factory.constructStereotype((ModelElement)dependency, "throws");
        }
        return result;
    }

    private Operation createMethod(MethodDoc doc) {
        String parameterComment;
        Parameter parameter;
        int i;
        Operation result = this.factory.constructOperation(doc.name());
        result.setSpecification(false);
        result.setQuery(false);
        this.factory.constructTagDocumentation((ModelElement)result, doc.commentText());
        if (doc.isPublic()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        } else if (doc.isPrivate()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PRIVATE);
        } else if (doc.isProtected()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PROTECTED);
        }
        if (doc.isStatic()) {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
        } else {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        }
        result.setAbstract(doc.isAbstract());
        result.setLeaf(doc.isFinal());
        if (doc.isSynchronized()) {
            result.setConcurrency((CallConcurrencyKind)CallConcurrencyKindEnum.CCK_SEQUENTIAL);
        } else {
            result.setConcurrency((CallConcurrencyKind)CallConcurrencyKindEnum.CCK_CONCURRENT);
        }
        com.sun.javadoc.Parameter[] parameters = doc.parameters();
        ParamTag[] parameterTags = doc.paramTags();
        for (i = 0; i < parameters.length; ++i) {
            parameter = this.createParameter(parameters[i].name(), parameters[i].type(), ParameterDirectionKindEnum.PDK_INOUT);
            parameter.setBehavioralFeature((BehavioralFeature)result);
            parameterComment = this.findComment(parameters[i].name(), parameterTags);
            if (parameterComment == null) continue;
            this.factory.constructTagDocumentation((ModelElement)parameter, parameterComment);
        }
        Type parameterTypeDoc = doc.returnType();
        if (parameterTypeDoc != null) {
            parameter = this.createParameter(RETURN_PARAMETER_NAME, doc.returnType(), ParameterDirectionKindEnum.PDK_RETURN);
            parameter.setBehavioralFeature((BehavioralFeature)result);
            parameterComment = this.findComment(JAVADOC_RETURN_TAG_NAME, doc.tags());
            if (parameterComment != null) {
                this.factory.constructTagDocumentation((ModelElement)parameter, parameterComment);
            }
        }
        ClassDoc[] exceptions = doc.thrownExceptions();
        for (i = 0; i < exceptions.length; ++i) {
            this.factory.constructException(exceptions[i].qualifiedName());
        }
        return result;
    }

    private Parameter createParameter(String parameterName, Type parameterType, ParameterDirectionKindEnum kind) {
        Classifier typeClassifier;
        Parameter result = this.factory.constructParameter(parameterName);
        try {
            typeClassifier = (Classifier)this.factory.locateModelElement(parameterType.qualifiedTypeName());
        }
        catch (IllegalArgumentException ex) {
            typeClassifier = this.factory.constructDataType(parameterType.qualifiedTypeName());
        }
        result.setType(typeClassifier);
        result.setKind((ParameterDirectionKind)kind);
        return result;
    }

    private Attribute createAttribute(FieldDoc fieldDoc) {
        Attribute result = this.factory.constructAttribute(fieldDoc.name());
        this.factory.constructTagDocumentation((ModelElement)result, fieldDoc.commentText());
        if (fieldDoc.isPublic()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        } else if (fieldDoc.isPrivate()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PRIVATE);
        } else if (fieldDoc.isProtected()) {
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PROTECTED);
        }
        if (fieldDoc.isStatic()) {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
        } else {
            result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        }
        if (fieldDoc.isFinal()) {
            result.setChangeability((ChangeableKind)ChangeableKindEnum.CK_FROZEN);
        } else {
            result.setChangeability((ChangeableKind)ChangeableKindEnum.CK_CHANGEABLE);
        }
        Type typeDoc = fieldDoc.type();
        this.assignTypeToAttribute(typeDoc, result);
        String initialValue = fieldDoc.constantValueExpression();
        if (initialValue != null && !initialValue.equals("")) {
            Expression initialValueExpression = this.factory.constructExpression(initialValue);
            result.setInitialValue(initialValueExpression);
        }
        return result;
    }

    private void assignTypeToAttribute(Type typeDoc, Attribute result) {
        int multiUpperBound;
        if (typeDoc.isPrimitive()) {
            Classifier type;
            try {
                type = (Classifier)this.factory.locateModelElement(typeDoc.simpleTypeName());
            }
            catch (IllegalArgumentException ex) {
                type = this.factory.constructDataType(typeDoc.simpleTypeName());
            }
            result.setType(type);
            multiUpperBound = this.isSingleValued(typeDoc) ? 1 : -1;
        } else {
            Classifier type;
            String associatedClassName;
            Class<?> declaredAttributeClass;
            try {
                declaredAttributeClass = Class.forName(typeDoc.qualifiedTypeName());
            }
            catch (Exception ex) {
                declaredAttributeClass = null;
            }
            if (declaredAttributeClass != null && Collection.class.isAssignableFrom(declaredAttributeClass)) {
                Type[] arguments;
                multiUpperBound = -1;
                ParameterizedType genericType = typeDoc.asParameterizedType();
                associatedClassName = genericType != null ? ((arguments = genericType.typeArguments()).length > 0 ? arguments[0].qualifiedTypeName() : Object.class.getName()) : Object.class.getName();
            } else {
                multiUpperBound = 1;
                associatedClassName = typeDoc.qualifiedTypeName();
            }
            try {
                type = (Classifier)this.factory.locateModelElement(associatedClassName);
            }
            catch (IllegalArgumentException ex) {
                type = this.factory.constructDataType(associatedClassName);
            }
            result.setType(type);
        }
        result.setMultiplicity(this.factory.constructMultiplicity(multiUpperBound));
    }

    private boolean isSingleValued(Type typeDoc) {
        return typeDoc.dimension() == null || typeDoc.dimension().equals("");
    }

    private String findComment(String tagName, Tag[] tags) {
        String result = null;
        for (int i = 0; result == null && i < tags.length; ++i) {
            if (!tagName.equals(tags[i].name())) continue;
            result = tags[i].text();
        }
        return result;
    }

    private String findComment(String parameterName, ParamTag[] parameterTags) {
        String result = null;
        for (int i = 0; result == null && i < parameterTags.length; ++i) {
            if (!parameterName.equals(parameterTags[i].parameterName())) continue;
            result = parameterTags[i].parameterComment();
        }
        return result;
    }
}

