/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.reverse;

import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.parser.AnnotationContext;
import com.sun.xml.xsom.parser.AnnotationParser;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.Function;
import net.mdatools.modelant.core.util.key.GenerateUniqueName;
import net.mdatools.modelant.repository.api.ModelFactory;
import net.mdatools.modelant.repository.api.ModelRepository;
import net.mdatools.modelant.uml13.reverse.Uml13ModelFactory;
import org.omg.uml13.foundation.core.Attribute;
import org.omg.uml13.foundation.core.Classifier;
import org.omg.uml13.foundation.core.ModelElement;
import org.omg.uml13.foundation.core.Namespace;
import org.omg.uml13.foundation.core.UmlAssociation;
import org.omg.uml13.foundation.core.UmlClass;
import org.omg.uml13.foundation.datatypes.ChangeableKind;
import org.omg.uml13.foundation.datatypes.ChangeableKindEnum;
import org.omg.uml13.foundation.datatypes.ScopeKind;
import org.omg.uml13.foundation.datatypes.ScopeKindEnum;
import org.omg.uml13.foundation.datatypes.VisibilityKind;
import org.omg.uml13.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml13.modelmanagement.UmlPackage;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReverseXsdOperation
implements Function<File, RefPackage> {
    static final Logger LOGGER = Logger.getLogger(ReverseXsdOperation.class.getName());
    private static final String ANONYMOUS_CLASS_NAME_PREFIX = "AnonymousType";
    private static final String INFERRED_CLASS_NAME_SUFFIX = "Type";
    private static final String INFERRED_GROUP_NAME_SUFFIX = "Group";
    private static final String INFERRED_UNION_NAME_SUFFIX = "United";
    private static final String EMPTY_ENUM_NAME_PREFIX = "EMPTY";
    private static final String ENUM_NAME_PREFIX = "ENUM_";
    private final ModelRepository modelRepository;
    private final Map<XSComponent, Classifier> typeToClassMap = new IdentityHashMap<XSComponent, Classifier>();
    private final GenerateUniqueName uniqueNamesGenerator = new GenerateUniqueName();
    private XSType anyType;
    private XSType stringType;
    private Uml13ModelFactory factory;

    public ReverseXsdOperation(ModelRepository modelRepository) {
        assert (modelRepository != null) : "Expected non-nulll model repository";
        this.modelRepository = modelRepository;
    }

    public RefPackage execute(File schemaFile) throws IllegalArgumentException {
        XSSchemaSet schemaSet;
        ModelFactory modelFactory = this.modelRepository.loadMetamodel("UML13");
        RefPackage result = modelFactory.instantiate();
        this.factory = new Uml13ModelFactory(result);
        XSOMParser parser = this.constructSchemaParser();
        try {
            parser.parse(schemaFile);
            schemaSet = parser.getResult();
        }
        catch (IOException | SAXException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (schemaSet != null) {
            this.anyType = schemaSet.getAnyType();
            this.stringType = schemaSet.getType("http://www.w3.org/2001/XMLSchema", "string");
            Iterator schemasIterator = schemaSet.iterateSchema();
            while (schemasIterator.hasNext()) {
                XSSchema schema = (XSSchema)schemasIterator.next();
                this.describeSchema(schema);
            }
        } else {
            throw new IllegalArgumentException("No valid/complete schemas parsed");
        }
        return result;
    }

    private XSOMParser constructSchemaParser() {
        XSOMParser parser = new XSOMParser();
        parser.setErrorHandler((ErrorHandler)new ParserErrorListerner());
        parser.setEntityResolver((EntityResolver)new SimpleEntityResolver());
        parser.setAnnotationParser((AnnotationParserFactory)new SimpleAnnotationParserFactory());
        return parser;
    }

    private void describeSchema(XSSchema schema) {
        XSType type;
        this.declareTargetNamespacePackage(schema);
        Iterator typeIterator = schema.iterateTypes();
        while (typeIterator.hasNext()) {
            type = (XSType)typeIterator.next();
            this.declareType((XSDeclaration)type);
        }
        typeIterator = schema.iterateTypes();
        while (typeIterator.hasNext()) {
            type = (XSType)typeIterator.next();
            this.defineType(type, this.locateType((XSComponent)type));
        }
        Iterator elementIterator = schema.iterateElementDecls();
        while (elementIterator.hasNext()) {
            XSElementDecl elementDecl = (XSElementDecl)elementIterator.next();
            this.createElement(elementDecl);
        }
    }

    private void declareTargetNamespacePackage(XSSchema schema) {
        UmlPackage namespace = this.factory.constructPackage(this.formatPackageName(schema.getTargetNamespace()));
        this.assignDocumentation((ModelElement)namespace, (XSComponent)schema);
    }

    private Classifier locateType(XSComponent type) {
        Classifier result = this.typeToClassMap.get(type);
        return result;
    }

    private Classifier declareType(XSDeclaration type) {
        UmlPackage namespace = this.factory.constructPackage(this.formatPackageName(type.getTargetNamespace()));
        String simpleTypeName = this.formatClassName(type.getName());
        LOGGER.log(Level.FINE, "Declare type: {0}", simpleTypeName);
        UmlClass result = this.factory.constructClass((Namespace)namespace, simpleTypeName);
        this.bindType((XSComponent)type, (Classifier)result);
        return result;
    }

    private Classifier declareLocalType(XSType type, String defaultName, Classifier umlClass) {
        if (type.getName() != null && !type.getName().isEmpty()) {
            defaultName = type.getName();
        }
        String simpleTypeName = this.formatClassName(defaultName);
        LOGGER.log(Level.FINE, "Declare local type: {0}", simpleTypeName);
        UmlPackage namespace = this.factory.constructPackage(this.formatPackageName(type.getTargetNamespace()));
        UmlClass result = this.factory.constructClass((Namespace)namespace, simpleTypeName);
        result.setAbstract(true);
        this.bindType((XSComponent)type, (Classifier)result);
        this.factory.constructTagDocumentation((ModelElement)result, "An anonymous type in the XSD");
        return result;
    }

    private void bindType(XSComponent type, Classifier result) {
        this.typeToClassMap.put(type, result);
        this.assignDocumentation((ModelElement)result, type);
    }

    private Classifier defineType(XSType type, Classifier intoClass) {
        LOGGER.log(Level.FINE, "Define type: {0}", type);
        if (type.isComplexType()) {
            this.processComplexType(type.asComplexType(), intoClass);
        } else {
            this.processSimpleType(type.asSimpleType(), intoClass);
        }
        return intoClass;
    }

    private void processSimpleType(XSSimpleType type, Classifier intoClass) {
        if (type.isRestriction()) {
            this.assignSuperclass((XSType)type, intoClass);
        }
        this.processSimpleContent(type, intoClass);
    }

    private void processSimpleContent(XSSimpleType type, Classifier intoClass) {
        if (type.isRestriction()) {
            LOGGER.log(Level.FINE, "Restriction");
            Iterator facetsItrator = ((XSRestrictionSimpleType)type).iterateDeclaredFacets();
            while (facetsItrator.hasNext()) {
                XSFacet facet = (XSFacet)facetsItrator.next();
                LOGGER.log(Level.FINE, "  Facet: {0}", facet);
                if (facet.getName().equals("length") || facet.getName().equals("maxLength") || facet.getName().equals("totalDigits")) {
                    this.factory.constructTagSize((ModelElement)intoClass, Integer.parseInt(facet.getValue().toString()));
                    continue;
                }
                if (facet.getName().equals("fractionDigits")) {
                    this.factory.constructTagFieldPrecision((ModelElement)intoClass, Integer.parseInt(facet.getValue().toString()));
                    continue;
                }
                if (facet.getName().equals("enumeration")) {
                    this.createConstant(facet, intoClass);
                    continue;
                }
                this.factory.constructTag((ModelElement)intoClass, facet.getName(), facet.getValue().toString());
            }
        } else if (type.isList()) {
            LOGGER.log(Level.FINE, "List");
            Classifier superClass = this.locateType((XSComponent)this.anyType);
            this.factory.constructGeneralization(intoClass, superClass);
            XSSimpleType unitedType = ((XSListSimpleType)type).getItemType();
            Classifier unitedClass = this.locateType((XSComponent)unitedType);
            if (unitedClass == null) {
                unitedClass = this.declareLocalType((XSType)unitedType, intoClass.getName() + INFERRED_CLASS_NAME_SUFFIX, intoClass);
                this.defineType((XSType)unitedType, unitedClass);
            }
            UmlAssociation assoc = this.factory.constructAssociation(intoClass, "", 1, true, false, unitedClass, "", -1, intoClass.getNamespace(), "A list of " + unitedType.getName());
            this.assignDocumentation((ModelElement)assoc, (XSComponent)unitedType);
            this.factory.constructTagDocumentation((ModelElement)intoClass, "This XSD type represents a list of " + unitedType.getName());
        } else if (type.isUnion()) {
            LOGGER.log(Level.FINE, "Union");
            for (XSSimpleType unitedType : (XSUnionSimpleType)type) {
                Classifier unitedClass = this.locateType((XSComponent)unitedType);
                if (unitedClass == null) {
                    unitedClass = this.declareLocalType((XSType)unitedType, type.getName() + INFERRED_UNION_NAME_SUFFIX, intoClass);
                    this.defineType((XSType)unitedType, this.locateType((XSComponent)type));
                }
                this.factory.constructGeneralization(intoClass, unitedClass);
            }
            this.factory.constructTagDocumentation((ModelElement)intoClass, "This XSD type represents an XSD union of simple types inheriting from all of them");
        } else {
            LOGGER.log(Level.SEVERE, "Unkown type: {0}", type);
        }
    }

    private void processComplexType(XSComplexType type, Classifier intoClass) {
        intoClass.setAbstract(type.isAbstract());
        this.assignSuperclass((XSType)type, intoClass);
        this.processAttributeContainer((XSAttContainer)type, intoClass);
        XSContentType contentType = type.getExplicitContent();
        if (contentType == null) {
            contentType = type.getContentType();
        }
        if (contentType instanceof XSSimpleType) {
            this.processSimpleContent(contentType.asSimpleType(), intoClass);
        } else if (contentType instanceof XSParticle) {
            this.processParticleAsComplexTypeContent(contentType.asParticle(), intoClass);
        }
    }

    private void assignSuperclass(XSType type, Classifier intoClass) {
        if (type != this.anyType) {
            Classifier superclass = this.locateType((XSComponent)type.getBaseType());
            if (superclass == null) {
                this.defineType(type.getBaseType(), intoClass);
            } else {
                this.factory.constructGeneralization(intoClass, superclass);
            }
        }
    }

    private void processAttributeContainer(XSAttContainer type, Classifier umlClass) {
        Iterator declaredAttributeUsesIterator = type.iterateDeclaredAttributeUses();
        while (declaredAttributeUsesIterator.hasNext()) {
            XSAttributeUse attributeUse = (XSAttributeUse)declaredAttributeUsesIterator.next();
            Attribute attribute = this.createAttribute(attributeUse.getDecl(), umlClass);
            if (type instanceof XSComplexType) continue;
            this.assignDocumentation((ModelElement)attribute, (XSComponent)type);
        }
        Iterator groupsIterator = type.iterateAttGroups();
        while (groupsIterator.hasNext()) {
            XSAttGroupDecl group = (XSAttGroupDecl)groupsIterator.next();
            this.processAttributeContainer((XSAttContainer)group, umlClass);
        }
    }

    private void processParticleAsComplexTypeContent(XSParticle particle, Classifier intoClass) {
        int otherEndUpper = particle.isRepeated() ? particle.getMaxOccurs().subtract(particle.getMinOccurs()).intValue() : 1;
        XSTerm term = particle.getTerm();
        if (term.isElementDecl()) {
            XSElementDecl elementDecl = (XSElementDecl)term;
            Classifier otherClass = this.locateType((XSComponent)elementDecl.getType());
            if (otherClass == null) {
                otherClass = this.declareLocalType(elementDecl.getType(), elementDecl.getName() + INFERRED_CLASS_NAME_SUFFIX, intoClass);
                this.defineType(elementDecl.getType(), otherClass);
                this.factory.constructTagDocumentation((ModelElement)otherClass, "A type inlined in an <xsd:element> declaration");
            }
            UmlAssociation assoc = this.factory.constructAssociation(intoClass, "", 1, true, false, otherClass, elementDecl.getName(), otherEndUpper, intoClass.getNamespace(), "A declared element of the type");
            this.assignDocumentation((ModelElement)assoc, (XSComponent)elementDecl);
            this.factory.constructStereotypeElement((ModelElement)assoc);
        } else if (term.isModelGroup()) {
            if (otherEndUpper == 1) {
                this.inlineModelGroup(term.asModelGroup(), intoClass);
            } else {
                String modelGroupName = this.formatClassName(intoClass.getName() + INFERRED_GROUP_NAME_SUFFIX);
                LOGGER.log(Level.FINE, "Create anonymous model group: {0}", modelGroupName);
                UmlClass otherClass = this.factory.constructClass(modelGroupName);
                this.bindType((XSComponent)term, (Classifier)otherClass);
                otherClass.setNamespace(intoClass.getNamespace());
                this.inlineModelGroup(term.asModelGroup(), (Classifier)otherClass);
                UmlAssociation assoc = this.factory.constructAssociation(intoClass, "", 1, true, false, (Classifier)otherClass, "", otherEndUpper, intoClass.getNamespace(), "A model element group - the elements are declared in its contents");
                this.assignDocumentation((ModelElement)assoc, (XSComponent)term);
                this.factory.constructTagDocumentation((ModelElement)otherClass, "A model group without any representation as <xsd:element>");
            }
        } else if (term.isModelGroupDecl()) {
            if (otherEndUpper == 1) {
                this.inlineModelGroup(term.asModelGroupDecl().getModelGroup(), intoClass);
            } else {
                Classifier otherClass = this.locateType((XSComponent)term.asModelGroupDecl());
                if (otherClass == null) {
                    String modelGroupName = this.formatClassName(term.asModelGroupDecl().getName() + INFERRED_GROUP_NAME_SUFFIX);
                    LOGGER.log(Level.FINE, "Create local model group: {0}", modelGroupName);
                    UmlPackage namespace = this.factory.constructPackage(this.formatPackageName(term.asModelGroupDecl().getTargetNamespace()));
                    otherClass = this.factory.constructClass((Namespace)namespace, modelGroupName);
                    this.bindType((XSComponent)term.asModelGroupDecl(), otherClass);
                    this.assignDocumentation((ModelElement)otherClass, (XSComponent)term);
                    this.inlineModelGroup(term.asModelGroupDecl().getModelGroup(), otherClass);
                }
                UmlAssociation assoc = this.factory.constructAssociation(intoClass, "", 1, true, false, otherClass, "", otherEndUpper, intoClass.getNamespace(), "An explicitly declared model element group - the elements are declared in its contents");
                this.assignDocumentation((ModelElement)assoc, (XSComponent)term);
                this.factory.constructTagDocumentation((ModelElement)otherClass, "A model group declaration without any representation as <xsd:element>");
            }
        }
    }

    private Attribute createAttribute(XSAttributeDecl declaration, Classifier umlClass) {
        LOGGER.log(Level.FINE, "  Attribute: {0}", declaration);
        Attribute result = this.factory.constructAttribute(declaration.getName());
        this.assignDocumentation((ModelElement)result, (XSComponent)declaration);
        Classifier attributeClass = this.locateType((XSComponent)declaration.getType());
        if (attributeClass == null) {
            attributeClass = this.declareLocalType((XSType)declaration.getType(), declaration.getName() + INFERRED_CLASS_NAME_SUFFIX, umlClass);
            this.defineType((XSType)declaration.getType(), attributeClass);
        }
        result.setOwner(umlClass);
        result.setType(attributeClass);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        if (declaration.getFixedValue() != null && declaration.getFixedValue().toString() != null) {
            result.setInitialValue(this.factory.constructExpression(declaration.getFixedValue().toString()));
            result.setChangeability((ChangeableKind)ChangeableKindEnum.CK_FROZEN);
            result.setTargetScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
        } else {
            if (declaration.getDefaultValue() != null && declaration.getDefaultValue().toString() != null) {
                result.setInitialValue(this.factory.constructExpression("\"" + declaration.getDefaultValue() + "\""));
            }
            result.setChangeability((ChangeableKind)ChangeableKindEnum.CK_CHANGEABLE);
            result.setTargetScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        }
        return result;
    }

    private Attribute createConstant(XSFacet declaration, Classifier umlClass) {
        Attribute result = this.factory.constructAttribute(this.formatConstant(declaration.getValue().value));
        this.assignDocumentation((ModelElement)result, (XSComponent)declaration);
        LOGGER.log(Level.FINE, "  Enumeration: {0}", result.getName());
        Classifier attributeClass = this.locateType((XSComponent)this.stringType);
        result.setOwner(umlClass);
        result.setType(attributeClass);
        result.setInitialValue(this.factory.constructExpression(declaration.getValue().toString()));
        result.setChangeability((ChangeableKind)ChangeableKindEnum.CK_FROZEN);
        result.setTargetScope((ScopeKind)ScopeKindEnum.SK_CLASSIFIER);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        return result;
    }

    private void inlineModelGroup(XSModelGroup modelGroup, Classifier result) {
        for (XSParticle particle : modelGroup) {
            this.processParticleAsComplexTypeContent(particle, result);
        }
        this.assignDocumentation((ModelElement)result, (XSComponent)modelGroup);
    }

    private void createElement(XSElementDecl elementDeclaration) {
        Classifier element = this.declareType((XSDeclaration)elementDeclaration);
        Classifier umlType = this.locateType((XSComponent)elementDeclaration.getType());
        if (umlType == null) {
            umlType = this.declareLocalType(elementDeclaration.getType(), elementDeclaration.getName() + INFERRED_CLASS_NAME_SUFFIX, element);
            this.defineType(elementDeclaration.getType(), umlType);
        }
        this.factory.constructGeneralization(element, umlType);
        this.factory.constructStereotypeElement((ModelElement)element);
    }

    private void assignDocumentation(ModelElement modelElement, XSComponent component) {
        if (component != null && component.getAnnotation() != null && component.getAnnotation().getAnnotation() instanceof String) {
            String comments = ((String)component.getAnnotation().getAnnotation()).trim();
            this.factory.constructTagDocumentation(modelElement, comments);
        }
    }

    private String formatClassName(String defaultName) {
        StringBuilder path = new StringBuilder(64);
        if (defaultName == null || defaultName.isEmpty()) {
            path.append(ANONYMOUS_CLASS_NAME_PREFIX);
        } else {
            path.append(defaultName);
        }
        String result = this.uniqueNamesGenerator.getUnique(path.toString());
        return result;
    }

    private String formatPackageName(String targetNamespace) {
        StringBuilder result = new StringBuilder(256);
        if (targetNamespace != null && !targetNamespace.isEmpty()) {
            try {
                URI namespace = new URI(targetNamespace);
                if (namespace.getPath() != null) {
                    StringTokenizer tokenizer = new StringTokenizer(namespace.getPath(), "/.-");
                    while (tokenizer.hasMoreElements()) {
                        String item = (String)tokenizer.nextElement();
                        if (result.length() > 0) {
                            result.append(".");
                        }
                        result.append(item);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    private String formatConstant(String defaultName) {
        String result;
        if (defaultName == null) {
            result = EMPTY_ENUM_NAME_PREFIX;
        } else {
            result = defaultName.replaceAll("[^A-Za-z0-9_$]+", "");
            if (result.isEmpty()) {
                result = this.uniqueNamesGenerator.getUnique(EMPTY_ENUM_NAME_PREFIX);
            } else if (!Character.isJavaIdentifierStart(result.charAt(0))) {
                result = ENUM_NAME_PREFIX + result;
            }
        }
        return result;
    }

    final class SimpleEntityResolver
    implements EntityResolver {
        SimpleEntityResolver() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url;
            if (systemId == null) {
                if (publicId == null) throw new IllegalArgumentException("Received null system and null public ID of XSD to import");
                url = new URL(publicId);
                LOGGER.log(Level.INFO, "Resolving {0} remotely", url);
                return new InputSource(url.toString());
            } else {
                url = new URL(systemId);
                LOGGER.log(Level.INFO, "Resolving {0} locally", url);
            }
            return new InputSource(url.toString());
        }
    }

    final class ParserErrorListerner
    implements ErrorHandler {
        ParserErrorListerner() {
        }

        @Override
        public void error(SAXParseException arg0) {
            LOGGER.log(Level.SEVERE, "", arg0);
        }

        @Override
        public void fatalError(SAXParseException arg0) {
            LOGGER.log(Level.SEVERE, "", arg0);
        }

        @Override
        public void warning(SAXParseException arg0) {
            LOGGER.log(Level.WARNING, "", arg0);
        }
    }

    protected static class AnnotationParserImpl
    extends AnnotationParser
    implements ContentHandler {
        private final StringBuilder result = new StringBuilder(256);

        protected AnnotationParserImpl() {
        }

        public ContentHandler getContentHandler(AnnotationContext context, String parentElementName, ErrorHandler errorHandler, EntityResolver entityResolver) {
            this.result.setLength(0);
            return this;
        }

        public Object getResult(Object existing) {
            return this.result.toString();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.result.append(new String(ch, start, length).replaceAll("[\t\r\n]", " "));
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    protected static class SimpleAnnotationParserFactory
    implements AnnotationParserFactory {
        protected SimpleAnnotationParserFactory() {
        }

        public AnnotationParser create() {
            return new AnnotationParserImpl();
        }
    }
}

