/*
 * Decompiled with CFR 0.152.
 */
package net.mdatools.modelant.uml13.reverse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import net.mdatools.modelant.core.api.name.ClassName;
import net.mdatools.modelant.core.api.name.Name;
import net.mdatools.modelant.core.api.name.PackageName;
import net.mdatools.modelant.core.name.ClassNameImpl;
import net.mdatools.modelant.core.name.NameImpl;
import net.mdatools.modelant.core.name.PackageNameImpl;
import org.omg.uml13.foundation.core.AssociationEnd;
import org.omg.uml13.foundation.core.Attribute;
import org.omg.uml13.foundation.core.Classifier;
import org.omg.uml13.foundation.core.DataType;
import org.omg.uml13.foundation.core.Dependency;
import org.omg.uml13.foundation.core.GeneralizableElement;
import org.omg.uml13.foundation.core.Generalization;
import org.omg.uml13.foundation.core.Interface;
import org.omg.uml13.foundation.core.ModelElement;
import org.omg.uml13.foundation.core.Namespace;
import org.omg.uml13.foundation.core.Operation;
import org.omg.uml13.foundation.core.Parameter;
import org.omg.uml13.foundation.core.UmlAssociation;
import org.omg.uml13.foundation.core.UmlClass;
import org.omg.uml13.foundation.datatypes.AggregationKind;
import org.omg.uml13.foundation.datatypes.AggregationKindEnum;
import org.omg.uml13.foundation.datatypes.Expression;
import org.omg.uml13.foundation.datatypes.Multiplicity;
import org.omg.uml13.foundation.datatypes.MultiplicityRange;
import org.omg.uml13.foundation.datatypes.ScopeKind;
import org.omg.uml13.foundation.datatypes.ScopeKindEnum;
import org.omg.uml13.foundation.datatypes.VisibilityKind;
import org.omg.uml13.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml13.foundation.extensionmechanisms.Stereotype;
import org.omg.uml13.foundation.extensionmechanisms.TaggedValue;
import org.omg.uml13.modelmanagement.Model;
import org.omg.uml13.modelmanagement.ModelClass;
import org.omg.uml13.modelmanagement.UmlPackage;

public class Uml13ModelFactory {
    public static final String STEREOTYPE_ELEMENT = "element";
    private static final PackageName foundation = new PackageNameImpl("Foundation");
    private static final PackageName core = new PackageNameImpl(foundation, "Core");
    private static final PackageName modelManagement;
    private static final PackageName dataTypes;
    private static final PackageName extensionMechanisms;
    private static final PackageName bebehavioralElements;
    private static final PackageName commonBehavior;
    private static final ClassName taggedValue;
    private static final ClassName attribute;
    private static final ClassName parameter;
    private static final ClassName className;
    private static final ClassName interfaceName;
    private static final ClassName dependencyName;
    private static final ClassName exceptionName;
    private static final ClassName expression;
    private static final ClassName umlPackage;
    private static final ClassName stereotype;
    private static final ClassName modelName;
    private static final ClassName generalization;
    private static final ClassName operationName;
    private static final ClassName association;
    private static final ClassName associationEnd;
    private static final ClassName multiplicity;
    private static final ClassName multiplicityRange;
    private static final ClassName dataType;
    private final RefPackage extent;
    private final Model model;

    public Uml13ModelFactory(RefPackage extent) {
        this.extent = extent;
        this.model = this.constructModel(extent);
    }

    private Model constructModel(RefPackage extent) {
        ModelClass metaClass = (ModelClass)modelName.getMetaClass(extent);
        Collection allModels = metaClass.refAllOfClass();
        Model result = allModels.isEmpty() ? (Model)metaClass.refCreateInstance(null) : (Model)allModels.iterator().next();
        return result;
    }

    public void setModelName(String modelName) {
        this.model.setName(modelName);
    }

    public UmlAssociation constructAssociation(Classifier thisClass, String thisRole, int thisEndUpper, boolean isComposition, boolean isThisNavigable, Classifier otherClass, String otherRole, int otherEndUpper, Namespace namespace, String documentation) {
        UmlAssociation result = (UmlAssociation)association.getMetaClass(this.extent).refCreateInstance(null);
        result.setNamespace(namespace);
        result.setName("");
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        AssociationEnd thisEnd = this.constructAssociationEnd(thisClass, thisRole, thisEndUpper, result);
        if (isComposition) {
            thisEnd.setAggregation((AggregationKind)AggregationKindEnum.AK_COMPOSITE);
        }
        this.constructAssociationEnd(otherClass, otherRole, otherEndUpper, result);
        return result;
    }

    private AssociationEnd constructAssociationEnd(Classifier thisClass, String thisRole, int thisEndUpper, UmlAssociation result) {
        AssociationEnd thisEnd = (AssociationEnd)associationEnd.getMetaClass(this.extent).refCreateInstance(null);
        thisEnd.setName(thisRole);
        thisEnd.setType(thisClass);
        thisEnd.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        thisEnd.setAssociation(result);
        thisEnd.setMultiplicity(this.constructMultiplicity(thisEndUpper));
        return thisEnd;
    }

    public Multiplicity constructMultiplicity(int otherEndUpper) {
        Multiplicity result = (Multiplicity)multiplicity.getMetaClass(this.extent).refCreateInstance(null);
        MultiplicityRange range = (MultiplicityRange)multiplicityRange.getMetaClass(this.extent).refCreateInstance(null);
        range.setUpper(otherEndUpper);
        result.getRange().add(range);
        return result;
    }

    public UmlClass constructClass(String simpleTypeName) {
        return this.constructClass((Namespace)this.model, simpleTypeName);
    }

    public UmlClass constructClass(Namespace namespace, String simpleTypeName) {
        UmlClass result;
        ModelElement lookedUp = this.locateLocalModelElement(namespace, simpleTypeName);
        if (lookedUp == null) {
            result = (UmlClass)className.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(simpleTypeName);
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
            result.setNamespace(namespace);
        } else if (lookedUp instanceof UmlClass) {
            result = (UmlClass)lookedUp;
        } else {
            throw new IllegalArgumentException("Expected to lookup a UmlClass instance for the name: " + namespace.getName() + "." + simpleTypeName + " isntead of " + lookedUp);
        }
        return result;
    }

    public DataType constructDataType(String dataTypeName) {
        DataType result;
        try {
            result = (DataType)this.locateModelElement(dataTypeName);
        }
        catch (IllegalArgumentException ex) {
            result = (DataType)dataType.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(dataTypeName);
            result.setNamespace((Namespace)this.model);
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        }
        return result;
    }

    public Attribute constructAttribute(String name) {
        Attribute result = (Attribute)attribute.getMetaClass(this.extent).refCreateInstance(null);
        result.setName(name);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        return result;
    }

    public Parameter constructParameter(String name) {
        Parameter result = (Parameter)parameter.getMetaClass(this.extent).refCreateInstance(null);
        result.setName(name);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        return result;
    }

    public Expression constructExpression(String body) {
        Expression result = (Expression)expression.getMetaClass(this.extent).refCreateInstance(null);
        result.setBody(body);
        return result;
    }

    public Interface constructInterface(Namespace umlPackage, String name) {
        Interface result = (Interface)this.locateLocalModelElement(umlPackage, name);
        if (result == null) {
            result = (Interface)interfaceName.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(name);
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
            result.setNamespace(umlPackage);
        }
        return result;
    }

    public Classifier constructException(String qualifiedName) {
        Classifier result = (Classifier)this.locateLocalModelElement((Namespace)this.model, qualifiedName);
        if (result == null) {
            result = (Classifier)exceptionName.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(qualifiedName);
            result.setNamespace((Namespace)this.model);
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        }
        return result;
    }

    public Operation constructOperation(String name) {
        Operation result = (Operation)operationName.getMetaClass(this.extent).refCreateInstance(null);
        result.setName(name);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        result.setOwnerScope((ScopeKind)ScopeKindEnum.SK_INSTANCE);
        return result;
    }

    public void constructGeneralization(Classifier subClass, Classifier superClass) {
        Generalization result = (Generalization)generalization.getMetaClass(this.extent).refCreateInstance(null);
        result.setNamespace(superClass.getNamespace());
        result.setParent((GeneralizableElement)superClass);
        result.setChild((GeneralizableElement)subClass);
    }

    public Dependency constructDependency(ModelElement client, ModelElement supplier, String name) {
        Dependency result = (Dependency)dependencyName.getMetaClass(this.extent).refCreateInstance(null);
        result.getSupplier().add(supplier);
        result.getClient().add(client);
        result.setNamespace((Namespace)this.model);
        result.setSpecification(false);
        result.setName(name);
        result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        return result;
    }

    public UmlPackage constructPackage(String name) {
        return this.constructPackage(NameImpl.parseQualifiedName((String)name));
    }

    public UmlPackage constructPackage(Name name) {
        Object namespace = name.getOwner() == null ? this.model : this.constructPackage(name.getOwner());
        UmlPackage result = (UmlPackage)this.locateLocalModelElement((Namespace)namespace, name.getName());
        if (result == null) {
            result = (UmlPackage)umlPackage.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(name.getName());
            result.setNamespace((Namespace)namespace);
        }
        return result;
    }

    public void constructStereotypeElement(ModelElement extendedElement) {
        this.constructStereotype(extendedElement, STEREOTYPE_ELEMENT);
    }

    public void constructStereotype(ModelElement extendedElement, String name) {
        Stereotype result = (Stereotype)this.locateLocalModelElement((Namespace)this.model, name);
        if (result == null) {
            result = (Stereotype)stereotype.getMetaClass(this.extent).refCreateInstance(null);
            result.setName(name);
            result.setNamespace((Namespace)this.model);
            result.setVisibility((VisibilityKind)VisibilityKindEnum.VK_PUBLIC);
        }
        result.getExtendedElement().add(extendedElement);
    }

    public TaggedValue getTaggedValue(ModelElement modelElement, String tagName) {
        TaggedValue result = null;
        Iterator<TaggedValue> sourceIterator = this.allTaggedValues(modelElement).iterator();
        while (result == null && sourceIterator.hasNext()) {
            TaggedValue tag = sourceIterator.next();
            if (!tagName.equals(tag.getTag())) continue;
            result = tag;
        }
        return result;
    }

    public void constructTagDocumentation(ModelElement otherClass, String contents) {
        TaggedValue documentation = this.getTaggedValue(otherClass, "documentation");
        if (documentation == null) {
            this.constructTag(otherClass, "documentation", contents);
        } else if (documentation.getValue() == null) {
            documentation.setValue(contents);
        } else if (documentation.getValue().indexOf(contents) < 0) {
            documentation.setValue(documentation.getValue() + "\n\r" + contents);
        }
    }

    private Collection<TaggedValue> allTaggedValues(ModelElement modelElement) {
        ArrayList<TaggedValue> result = new ArrayList<TaggedValue>();
        for (TaggedValue tag : taggedValue.getMetaClass(this.extent).refAllOfClass()) {
            if (tag.getModelElement() != modelElement) continue;
            result.add(tag);
        }
        return result;
    }

    public void constructTag(ModelElement modelElement, String name, String value) {
        TaggedValue result = (TaggedValue)taggedValue.getMetaClass(this.extent).refCreateInstance(null);
        result.setTag(name);
        result.setValue(value);
        result.setModelElement(modelElement);
    }

    public void constructTagFieldPrecision(ModelElement intoClass, int precision) {
        this.constructTag(intoClass, "scale", "" + precision);
    }

    public void constructTagSize(ModelElement intoClass, int parseInt) {
        this.constructTag(intoClass, "length", "" + parseInt);
    }

    public void constructTagPersistent(UmlClass intoClass) {
        this.constructTag((ModelElement)intoClass, "persistence", "persistent");
    }

    public void constructTagPrimaryKey(Attribute attribute, int order) {
        this.constructTag((ModelElement)attribute, "primary_key", Integer.toString(order));
    }

    public RefObject locateModelElement(String qualifiedName) throws IllegalArgumentException {
        return this.locateModelElement((Namespace)this.model, NameImpl.parseQualifiedName((String)qualifiedName));
    }

    public RefObject locateModelElement(Name<?> name) throws IllegalArgumentException {
        return this.locateModelElement((Namespace)this.model, name);
    }

    public RefObject locateModelElement(Namespace namespace, Name<?> name) throws IllegalArgumentException {
        Object resultNamespace = name.getOwner() != null ? this.locateModelElement(namespace, name.getOwner()) : namespace;
        if (!(resultNamespace instanceof Namespace)) {
            throw new IllegalArgumentException("Looking up " + name.getOwner() + " reached a non-namespace element to lookup " + name.getName());
        }
        ModelElement result = this.locateLocalModelElement((Namespace)resultNamespace, name.getName());
        if (result == null) {
            throw new IllegalArgumentException("Not found " + name + " in " + name.getOwner() + " namespace");
        }
        return result;
    }

    public ModelElement locateLocalModelElement(Namespace namespace, String elementName) {
        ModelElement result = null;
        Iterator ownedElementsIterator = namespace.getOwnedElement().iterator();
        while (result == null && ownedElementsIterator.hasNext()) {
            ModelElement ownedElement = (ModelElement)ownedElementsIterator.next();
            if (!elementName.equals(ownedElement.getName())) continue;
            result = ownedElement;
        }
        return result;
    }

    static {
        dataTypes = new PackageNameImpl(foundation, "Data_Types");
        extensionMechanisms = new PackageNameImpl(foundation, "Extension_Mechanisms");
        modelManagement = new PackageNameImpl("Model_Management");
        bebehavioralElements = new PackageNameImpl("Behavioral_Elements");
        commonBehavior = new PackageNameImpl(bebehavioralElements, "Common_Behavior");
        taggedValue = new ClassNameImpl(extensionMechanisms, "TaggedValue");
        attribute = new ClassNameImpl(core, "Attribute");
        parameter = new ClassNameImpl(core, "Parameter");
        className = new ClassNameImpl(core, "Class");
        interfaceName = new ClassNameImpl(core, "Interface");
        exceptionName = new ClassNameImpl(commonBehavior, "Exception");
        operationName = new ClassNameImpl(core, "Operation");
        dependencyName = new ClassNameImpl(core, "Dependency");
        association = new ClassNameImpl(core, "Association");
        associationEnd = new ClassNameImpl(core, "AssociationEnd");
        dataType = new ClassNameImpl(core, "DataType");
        expression = new ClassNameImpl(dataTypes, "Expression");
        umlPackage = new ClassNameImpl(modelManagement, "Package");
        modelName = new ClassNameImpl(modelManagement, "Model");
        stereotype = new ClassNameImpl(extensionMechanisms, "Stereotype");
        generalization = new ClassNameImpl(core, "Generalization");
        multiplicity = new ClassNameImpl(dataTypes, "Multiplicity");
        multiplicityRange = new ClassNameImpl(dataTypes, "MultiplicityRange");
    }
}

