/*
 * Decompiled with CFR 0.152.
 */
package net.media.openrtb25.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import net.media.openrtb25.request.NativeRequest;
import net.media.openrtb25.request.NativeRequestBody;
import net.media.utils.JacksonObjectMapper;

public class Native {
    public static final String DEFAULT_NATIVE_VERSION = "1.1";
    @NotNull
    private Object request;
    private String ver = "1.1";
    private Collection<Integer> api;
    private Collection<Integer> battr;
    private Map<String, Object> ext;
    @Valid
    private transient NativeRequestBody nativeRequestBody;
    private transient String requestAsString;

    public NativeRequestBody getNativeRequestBody() {
        NativeRequestBody nativeRequestBody;
        if (Objects.nonNull(this.nativeRequestBody)) {
            return this.nativeRequestBody;
        }
        if (Objects.isNull(this.request)) {
            return null;
        }
        if (this.request instanceof String) {
            String nativeRequestString;
            this.requestAsString = nativeRequestString = (String)this.request;
            try {
                nativeRequestBody = JacksonObjectMapper.getMapper().readValue(nativeRequestString, NativeRequestBody.class);
            }
            catch (IOException e) {
                return null;
            }
        } else {
            NativeRequest nativeRequest = JacksonObjectMapper.getMapper().convertValue(this.request, NativeRequest.class);
            nativeRequestBody = JacksonObjectMapper.getMapper().convertValue((Object)nativeRequest.getNativeRequestBody(), NativeRequestBody.class);
        }
        return nativeRequestBody;
    }

    public void setNativeRequestBody(NativeRequestBody nativeRequestBody) {
        this.nativeRequestBody = nativeRequestBody;
    }

    public String getRequestAsString() {
        if (Objects.nonNull(this.request) && this.request instanceof String) {
            this.requestAsString = (String)this.request;
        }
        return this.requestAsString;
    }

    public void setRequestAsString(String requestAsString) {
        this.requestAsString = requestAsString;
    }

    @NotNull
    public Object getRequest() {
        return this.request;
    }

    public void setRequest(@NotNull Object request) {
        this.request = request;
    }

    public String getVer() {
        return this.ver;
    }

    public void setVer(String ver) {
        this.ver = ver;
    }

    public Collection<Integer> getApi() {
        return this.api;
    }

    public void setApi(Collection<Integer> api) {
        this.api = api;
    }

    public Collection<Integer> getBattr() {
        return this.battr;
    }

    public void setBattr(Collection<Integer> battr) {
        this.battr = battr;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Native aNative = (Native)o;
        return Objects.equals(this.getRequest(), aNative.getRequest()) && Objects.equals(this.getVer(), aNative.getVer()) && Objects.equals(this.getApi(), aNative.getApi()) && Objects.equals(this.getBattr(), aNative.getBattr()) && Objects.equals(this.getExt(), aNative.getExt()) && Objects.equals(this.getNativeRequestBody(), aNative.getNativeRequestBody()) && Objects.equals(this.getRequestAsString(), aNative.getRequestAsString());
    }

    public int hashCode() {
        return Objects.hash(this.getRequest(), this.getVer(), this.getApi(), this.getBattr(), this.getExt(), this.getNativeRequestBody(), this.getRequestAsString());
    }
}

