/*
 * Decompiled with CFR 0.152.
 */
package net.media.openrtb3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.media.openrtb3.Deal;
import net.media.openrtb3.Metric;
import net.media.openrtb3.Spec;

public class Item {
    private static final Integer DEFAULT_QUANTITY = 1;
    private static final Integer DEFAULT_DELIVERY_METHOD = 0;
    @NotBlank
    private String id;
    private Integer qty = DEFAULT_QUANTITY;
    private Integer seq;
    private double flr;
    private String flrcur;
    private Integer exp;
    private Integer dt;
    private Integer dlvy = DEFAULT_DELIVERY_METHOD;
    @Valid
    private Collection<Metric> metric;
    @Valid
    private Collection<Deal> deal;
    @JsonProperty(value="private")
    private Integer priv;
    @NotNull
    @Valid
    private Spec spec;
    private Map<String, Object> ext;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getQty() {
        return this.qty;
    }

    public void setQty(Integer qty) {
        this.qty = qty;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public double getFlr() {
        return this.flr;
    }

    public void setFlr(double flr) {
        this.flr = flr;
    }

    public String getFlrcur() {
        return this.flrcur;
    }

    public void setFlrcur(String flrcur) {
        this.flrcur = flrcur;
    }

    public Integer getExp() {
        return this.exp;
    }

    public void setExp(Integer exp) {
        this.exp = exp;
    }

    public Integer getDt() {
        return this.dt;
    }

    public void setDt(Integer dt) {
        this.dt = dt;
    }

    public Integer getDlvy() {
        return this.dlvy;
    }

    public void setDlvy(Integer dlvy) {
        this.dlvy = dlvy;
    }

    public Collection<Metric> getMetric() {
        return this.metric;
    }

    public void setMetric(Collection<Metric> metric) {
        this.metric = metric;
    }

    public Collection<Deal> getDeal() {
        return this.deal;
    }

    public void setDeal(Collection<Deal> deal) {
        this.deal = deal;
    }

    public Integer getPriv() {
        return this.priv;
    }

    public void setPriv(Integer priv) {
        this.priv = priv;
    }

    @NotNull
    public Spec getSpec() {
        return this.spec;
    }

    public void setSpec(@NotNull Spec spec) {
        this.spec = spec;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Double.compare(item.getFlr(), this.getFlr()) == 0 && Objects.equals(this.getId(), item.getId()) && Objects.equals(this.getQty(), item.getQty()) && Objects.equals(this.getSeq(), item.getSeq()) && Objects.equals(this.getFlrcur(), item.getFlrcur()) && Objects.equals(this.getExp(), item.getExp()) && Objects.equals(this.getDt(), item.getDt()) && Objects.equals(this.getDlvy(), item.getDlvy()) && Objects.equals(this.getMetric(), item.getMetric()) && Objects.equals(this.getDeal(), item.getDeal()) && Objects.equals(this.getPriv(), item.getPriv()) && Objects.equals(this.getSpec(), item.getSpec()) && Objects.equals(this.getExt(), item.getExt());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getQty(), this.getSeq(), this.getFlr(), this.getFlrcur(), this.getExp(), this.getDt(), this.getDlvy(), this.getMetric(), this.getDeal(), this.getPriv(), this.getSpec(), this.getExt());
    }
}

