/*
 * Decompiled with CFR 0.152.
 */
package net.media.openrtb3;

import java.util.Collection;
import java.util.Objects;
import javax.validation.Valid;
import net.media.openrtb3.AudioPlacement;
import net.media.openrtb3.DisplayPlacement;
import net.media.openrtb3.VideoPlacement;
import net.media.utils.validator.CheckAtLeastOneNotNull;

@CheckAtLeastOneNotNull(fieldNames={"display", "video", "audio"})
public class Placement {
    private static final Integer DEFAULT_SERVER_SIDE_AD_INSERTION = 0;
    private static final Integer DEFAULT_REWARDED_PLACEMENT = 0;
    private String tagid;
    private Integer ssai = DEFAULT_SERVER_SIDE_AD_INSERTION;
    private String sdk;
    private String sdkver;
    private Integer reward = DEFAULT_REWARDED_PLACEMENT;
    private Collection<String> wlang;
    private Integer secure;
    private Integer admx;
    private Integer curlx;
    @Valid
    private DisplayPlacement display;
    @Valid
    private VideoPlacement video;
    @Valid
    private AudioPlacement audio;
    private Object ext;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Placement placement = (Placement)o;
        return Objects.equals(this.getTagid(), placement.getTagid()) && Objects.equals(this.getSsai(), placement.getSsai()) && Objects.equals(this.getSdk(), placement.getSdk()) && Objects.equals(this.getSdkver(), placement.getSdkver()) && Objects.equals(this.getReward(), placement.getReward()) && Objects.equals(this.getWlang(), placement.getWlang()) && Objects.equals(this.getSecure(), placement.getSecure()) && Objects.equals(this.getAdmx(), placement.getAdmx()) && Objects.equals(this.getCurlx(), placement.getCurlx()) && Objects.equals(this.getDisplay(), placement.getDisplay()) && Objects.equals(this.getVideo(), placement.getVideo()) && Objects.equals(this.getAudio(), placement.getAudio()) && Objects.equals(this.getExt(), placement.getExt());
    }

    public int hashCode() {
        return Objects.hash(this.getTagid(), this.getSsai(), this.getSdk(), this.getSdkver(), this.getReward(), this.getWlang(), this.getSecure(), this.getAdmx(), this.getCurlx(), this.getDisplay(), this.getVideo(), this.getAudio(), this.getExt());
    }

    public String getTagid() {
        return this.tagid;
    }

    public void setTagid(String tagid) {
        this.tagid = tagid;
    }

    public Integer getSsai() {
        return this.ssai;
    }

    public void setSsai(Integer ssai) {
        this.ssai = ssai;
    }

    public String getSdk() {
        return this.sdk;
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
    }

    public String getSdkver() {
        return this.sdkver;
    }

    public void setSdkver(String sdkver) {
        this.sdkver = sdkver;
    }

    public Integer getReward() {
        return this.reward;
    }

    public void setReward(Integer reward) {
        this.reward = reward;
    }

    public Collection<String> getWlang() {
        return this.wlang;
    }

    public void setWlang(Collection<String> wlang) {
        this.wlang = wlang;
    }

    public Integer getSecure() {
        return this.secure;
    }

    public void setSecure(Integer secure) {
        this.secure = secure;
    }

    public Integer getAdmx() {
        return this.admx;
    }

    public void setAdmx(Integer admx) {
        this.admx = admx;
    }

    public Integer getCurlx() {
        return this.curlx;
    }

    public void setCurlx(Integer curlx) {
        this.curlx = curlx;
    }

    @Valid
    public DisplayPlacement getDisplay() {
        return this.display;
    }

    public void setDisplay(@Valid DisplayPlacement display) {
        this.display = display;
    }

    @Valid
    public VideoPlacement getVideo() {
        return this.video;
    }

    public void setVideo(@Valid VideoPlacement video) {
        this.video = video;
    }

    @Valid
    public AudioPlacement getAudio() {
        return this.audio;
    }

    public void setAudio(@Valid AudioPlacement audio) {
        this.audio = audio;
    }

    public Object getExt() {
        return this.ext;
    }

    public void setExt(Object ext) {
        this.ext = ext;
    }
}

