/*
 * Decompiled with CFR 0.152.
 */
package net.media.utils.validator;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import net.media.utils.validator.ValidatorErrorHandler;
import org.apache.commons.beanutils.PropertyUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Constraint(validatedBy={CheckAtLeastOneNotNullValidator.class})
@Documented
public @interface CheckAtLeastOneNotNull {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String[] fieldNames();

    public static class CheckAtLeastOneNotNullValidator
    implements ConstraintValidator<CheckAtLeastOneNotNull, Object> {
        private String[] fieldNames;

        @Override
        public void initialize(CheckAtLeastOneNotNull constraint) {
            this.fieldNames = constraint.fieldNames();
        }

        @Override
        public boolean isValid(Object object, ConstraintValidatorContext context) {
            if (object == null) {
                return true;
            }
            try {
                for (String fieldName : this.fieldNames) {
                    Object property = PropertyUtils.getProperty(object, fieldName);
                    if (property == null) continue;
                    return true;
                }
                ValidatorErrorHandler.setErrorMessage(context, "atleast one of the following should be present: " + Arrays.toString(this.fieldNames));
                return false;
            }
            catch (Exception e) {
                ValidatorErrorHandler.setErrorMessage(context, "atleast one of the following should be present: " + Arrays.toString(this.fieldNames));
                return false;
            }
        }
    }
}

