/*
 * Decompiled with CFR 0.152.
 */
package net.media.utils.validator;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import net.media.utils.validator.ValidatorErrorHandler;
import org.apache.commons.beanutils.PropertyUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Constraint(validatedBy={CheckExactlyOneNotNullValidator.class})
@Documented
public @interface CheckExactlyOneWithExt {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String[] fieldNames();

    public String[] extFieldNames();

    public static class CheckExactlyOneNotNullValidator
    implements ConstraintValidator<CheckExactlyOneWithExt, Object> {
        private String[] fieldNames;
        private String[] extFieldNames;

        @Override
        public void initialize(CheckExactlyOneWithExt constraint) {
            this.fieldNames = constraint.fieldNames();
            this.extFieldNames = constraint.extFieldNames();
        }

        @Override
        public boolean isValid(Object object, ConstraintValidatorContext context) {
            if (object == null) {
                return true;
            }
            boolean firstField = false;
            try {
                for (String fieldName : this.fieldNames) {
                    Object property = PropertyUtils.getProperty(object, fieldName);
                    if (property == null) continue;
                    if (firstField) {
                        return this.returnFailedValidation(context);
                    }
                    firstField = true;
                }
                Object extObject = PropertyUtils.getProperty(object, "ext");
                if (extObject != null) {
                    for (String fieldName : this.extFieldNames) {
                        Object property = PropertyUtils.getProperty(extObject, fieldName);
                        if (property == null) continue;
                        if (firstField) {
                            return this.returnFailedValidation(context);
                        }
                        firstField = true;
                    }
                }
                if (firstField) {
                    return true;
                }
                return this.returnFailedValidation(context);
            }
            catch (Exception e) {
                return this.returnFailedValidation(context);
            }
        }

        boolean returnFailedValidation(ConstraintValidatorContext context) {
            ValidatorErrorHandler.setErrorMessage(context, "Exactly one of the following should be present: " + Arrays.toString(this.fieldNames) + "in object or" + Arrays.toString(this.extFieldNames) + " in object.ext");
            return false;
        }
    }
}

