/*
 * Decompiled with CFR 0.152.
 */
package net.media.utils.validator;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import net.media.openrtb3.Event;
import net.media.utils.validator.ValidatorErrorHandler;
import org.apache.commons.lang3.StringUtils;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Constraint(validatedBy={Validator.class})
@Documented
public @interface Ortb3EventObjectValidator {
    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<Ortb3EventObjectValidator, Event> {
        @Override
        public boolean isValid(Event event, ConstraintValidatorContext context) {
            if (event == null || event.getMethod() == null) {
                return true;
            }
            int method = event.getMethod();
            if (1 == method || 2 == method) {
                if (StringUtils.isNotBlank(event.getUrl())) {
                    return true;
                }
                ValidatorErrorHandler.setErrorMessage(context, "Event.url is required for given Event.method(" + method + ").");
                return false;
            }
            return true;
        }
    }
}

