/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Executable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationContext<T> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final ConstraintValidatorManager constraintValidatorManager;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final BeanMetaData<T> rootBeanMetaData;
    private final Executable executable;
    private final Object[] executableParameters;
    private final Object executableReturnValue;
    private final Set<Object> processedUnits;
    private final Map<Object, Set<PathImpl>> processedPathsPerBean;
    private final Set<ConstraintViolation<T>> failingConstraintViolations;
    private final MessageInterpolator messageInterpolator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final TraversableResolver traversableResolver;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ClockProvider clockProvider;
    private final boolean failFast;
    private final HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext;
    private String validatedProperty;

    private ValidationContext(ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, ExecutableParameterNameProvider parameterNameProvider, ClockProvider clockProvider, HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext, boolean failFast, T rootBean, Class<T> rootBeanClass, BeanMetaData<T> rootBeanMetaData, Executable executable, Object[] executableParameters, Object executableReturnValue) {
        this.constraintValidatorManager = constraintValidatorManager;
        this.messageInterpolator = messageInterpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.parameterNameProvider = parameterNameProvider;
        this.clockProvider = clockProvider;
        this.constraintValidatorInitializationContext = constraintValidatorInitializationContext;
        this.failFast = failFast;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.rootBeanMetaData = rootBeanMetaData;
        this.executable = executable;
        this.executableParameters = executableParameters;
        this.executableReturnValue = executableReturnValue;
        this.processedUnits = new HashSet<Object>();
        this.processedPathsPerBean = new IdentityHashMap<Object, Set<PathImpl>>();
        this.failingConstraintViolations = CollectionHelper.newHashSet();
    }

    public static ValidationContextBuilder getValidationContextBuilder(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, ClockProvider clockProvider, HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext, boolean failFast) {
        return new ValidationContextBuilder(beanMetaDataManager, constraintValidatorManager, messageInterpolator, constraintValidatorFactory, traversableResolver, clockProvider, constraintValidatorInitializationContext, failFast);
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    public BeanMetaData<T> getRootBeanMetaData() {
        return this.rootBeanMetaData;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public boolean isFailFastModeEnabled() {
        return this.failFast;
    }

    public ConstraintValidatorManager getConstraintValidatorManager() {
        return this.constraintValidatorManager;
    }

    public List<String> getParameterNames() {
        if (this.parameterNameProvider == null) {
            return null;
        }
        return this.parameterNameProvider.getParameterNames(this.executable);
    }

    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    public HibernateConstraintValidatorInitializationContext getConstraintValidatorInitializationContext() {
        return this.constraintValidatorInitializationContext;
    }

    public Set<ConstraintViolation<T>> createConstraintViolations(ValueContext<?, ?> localContext, ConstraintValidatorContextImpl constraintValidatorContext) {
        return constraintValidatorContext.getConstraintViolationCreationContexts().stream().map(c -> this.createConstraintViolation(localContext, (ConstraintViolationCreationContext)c, constraintValidatorContext.getConstraintDescriptor())).collect(Collectors.toSet());
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public boolean isBeanAlreadyValidated(Object value, Class<?> group, PathImpl path) {
        boolean alreadyValidated = this.isAlreadyValidatedForCurrentGroup(value, group);
        if (alreadyValidated) {
            alreadyValidated = this.isAlreadyValidatedForPath(value, path);
        }
        return alreadyValidated;
    }

    public void markCurrentBeanAsProcessed(ValueContext<?, ?> valueContext) {
        this.markCurrentBeanAsProcessedForCurrentGroup(valueContext.getCurrentBean(), valueContext.getCurrentGroup());
        this.markCurrentBeanAsProcessedForCurrentPath(valueContext.getCurrentBean(), valueContext.getPropertyPath());
    }

    public void addConstraintFailures(Set<ConstraintViolation<T>> failingConstraintViolations) {
        this.failingConstraintViolations.addAll(failingConstraintViolations);
    }

    public Set<ConstraintViolation<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public ConstraintViolation<T> createConstraintViolation(ValueContext<?, ?> localContext, ConstraintViolationCreationContext constraintViolationCreationContext, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = constraintViolationCreationContext.getMessage();
        String interpolatedMessage = this.interpolate(messageTemplate, localContext.getCurrentValidatedValue(), descriptor, constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables());
        PathImpl path = PathImpl.createCopy(constraintViolationCreationContext.getPath());
        Object dynamicPayload = constraintViolationCreationContext.getDynamicPayload();
        if (this.executableParameters != null) {
            return ConstraintViolationImpl.forParameterValidation(messageTemplate, constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables(), interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableParameters, dynamicPayload);
        }
        if (this.executableReturnValue != null) {
            return ConstraintViolationImpl.forReturnValueValidation(messageTemplate, constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables(), interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), this.executableReturnValue, dynamicPayload);
        }
        return ConstraintViolationImpl.forBeanValidation(messageTemplate, constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables(), interpolatedMessage, this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), path, descriptor, localContext.getElementType(), dynamicPayload);
    }

    public boolean hasMetaConstraintBeenProcessed(Object bean, Path path, MetaConstraint<?> metaConstraint) {
        return this.processedUnits.contains(new BeanPathMetaConstraintProcessedUnit(bean, path, metaConstraint));
    }

    public void markConstraintProcessed(Object bean, Path path, MetaConstraint<?> metaConstraint) {
        this.processedUnits.add(new BeanPathMetaConstraintProcessedUnit(bean, path, metaConstraint));
    }

    public String getValidatedProperty() {
        return this.validatedProperty;
    }

    public void setValidatedProperty(String validatedProperty) {
        this.validatedProperty = validatedProperty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationContext");
        sb.append("{rootBean=").append(this.rootBean);
        sb.append('}');
        return sb.toString();
    }

    private String interpolate(String messageTemplate, Object validatedValue, ConstraintDescriptor<?> descriptor, Map<String, Object> messageParameters, Map<String, Object> expressionVariables) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(descriptor, validatedValue, this.getRootBeanClass(), messageParameters, expressionVariables);
        try {
            return this.messageInterpolator.interpolate(messageTemplate, context);
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw LOG.getExceptionOccurredDuringMessageInterpolationException(e);
        }
    }

    private boolean isAlreadyValidatedForPath(Object value, PathImpl path) {
        Set<PathImpl> pathSet = this.processedPathsPerBean.get(value);
        if (pathSet == null) {
            return false;
        }
        for (PathImpl p : pathSet) {
            if (!path.isRootPath() && !p.isRootPath() && !this.isSubPathOf(path, p) && !this.isSubPathOf(p, path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubPathOf(Path p1, Path p2) {
        Iterator p1Iter = p1.iterator();
        Iterator p2Iter = p2.iterator();
        while (p1Iter.hasNext()) {
            Path.Node p1Node = (Path.Node)p1Iter.next();
            if (!p2Iter.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iter.next();
            if (p1Node.equals(p2Node)) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyValidatedForCurrentGroup(Object value, Class<?> group) {
        return this.processedUnits.contains(new BeanGroupProcessedUnit(value, group));
    }

    private void markCurrentBeanAsProcessedForCurrentPath(Object bean, PathImpl path) {
        this.processedPathsPerBean.computeIfAbsent(bean, b -> new HashSet()).add(PathImpl.createCopy(path));
    }

    private void markCurrentBeanAsProcessedForCurrentGroup(Object bean, Class<?> group) {
        this.processedUnits.add(new BeanGroupProcessedUnit(bean, group));
    }

    private static final class BeanPathMetaConstraintProcessedUnit {
        private Object bean;
        private Path path;
        private MetaConstraint<?> metaConstraint;
        private int hashCode;

        private BeanPathMetaConstraintProcessedUnit(Object bean, Path path, MetaConstraint<?> metaConstraint) {
            this.bean = bean;
            this.path = path;
            this.metaConstraint = metaConstraint;
            this.hashCode = this.createHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != BeanPathMetaConstraintProcessedUnit.class) {
                return false;
            }
            BeanPathMetaConstraintProcessedUnit that = (BeanPathMetaConstraintProcessedUnit)o;
            if (this.bean != that.bean) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
            return this.metaConstraint == that.metaConstraint;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int createHashCode() {
            int result = System.identityHashCode(this.bean);
            result = 31 * result + this.path.hashCode();
            result = 31 * result + System.identityHashCode(this.metaConstraint);
            return result;
        }
    }

    private static final class BeanGroupProcessedUnit {
        private Object bean;
        private Class<?> group;
        private int hashCode;

        private BeanGroupProcessedUnit(Object bean, Class<?> group) {
            this.bean = bean;
            this.group = group;
            this.hashCode = this.createHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != BeanGroupProcessedUnit.class) {
                return false;
            }
            BeanGroupProcessedUnit that = (BeanGroupProcessedUnit)o;
            if (this.bean != that.bean) {
                return false;
            }
            return this.group.equals(that.group);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int createHashCode() {
            int result = System.identityHashCode(this.bean);
            result = 31 * result + this.group.hashCode();
            return result;
        }
    }

    public static class ValidationContextBuilder {
        private final BeanMetaDataManager beanMetaDataManager;
        private final ConstraintValidatorManager constraintValidatorManager;
        private final MessageInterpolator messageInterpolator;
        private final ConstraintValidatorFactory constraintValidatorFactory;
        private final TraversableResolver traversableResolver;
        private final ClockProvider clockProvider;
        private final HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext;
        private final boolean failFast;

        private ValidationContextBuilder(BeanMetaDataManager beanMetaDataManager, ConstraintValidatorManager constraintValidatorManager, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, ClockProvider clockProvider, HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext, boolean failFast) {
            this.beanMetaDataManager = beanMetaDataManager;
            this.constraintValidatorManager = constraintValidatorManager;
            this.messageInterpolator = messageInterpolator;
            this.constraintValidatorFactory = constraintValidatorFactory;
            this.traversableResolver = traversableResolver;
            this.clockProvider = clockProvider;
            this.constraintValidatorInitializationContext = constraintValidatorInitializationContext;
            this.failFast = failFast;
        }

        public <T> ValidationContext<T> forValidate(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.clockProvider, this.constraintValidatorInitializationContext, this.failFast, rootBean, rootBeanClass, this.beanMetaDataManager.getBeanMetaData(rootBeanClass), null, null, null);
        }

        public <T> ValidationContext<T> forValidateProperty(T rootBean) {
            Class<?> rootBeanClass = rootBean.getClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.clockProvider, this.constraintValidatorInitializationContext, this.failFast, rootBean, rootBeanClass, this.beanMetaDataManager.getBeanMetaData(rootBeanClass), null, null, null);
        }

        public <T> ValidationContext<T> forValidateValue(Class<T> rootBeanClass) {
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.clockProvider, this.constraintValidatorInitializationContext, this.failFast, null, rootBeanClass, this.beanMetaDataManager.getBeanMetaData(rootBeanClass), null, null, null);
        }

        public <T> ValidationContext<T> forValidateParameters(ExecutableParameterNameProvider parameterNameProvider, T rootBean, Executable executable, Object[] executableParameters) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getDeclaringClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, parameterNameProvider, this.clockProvider, this.constraintValidatorInitializationContext, this.failFast, rootBean, rootBeanClass, this.beanMetaDataManager.getBeanMetaData(rootBeanClass), executable, executableParameters, null);
        }

        public <T> ValidationContext<T> forValidateReturnValue(T rootBean, Executable executable, Object executableReturnValue) {
            Class<?> rootBeanClass = rootBean != null ? rootBean.getClass() : executable.getDeclaringClass();
            return new ValidationContext(this.constraintValidatorManager, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver, null, this.clockProvider, this.constraintValidatorInitializationContext, this.failFast, rootBean, rootBeanClass, this.beanMetaDataManager.getBeanMetaData(rootBeanClass), executable, null, executableReturnValue);
        }
    }
}

