/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.scheduler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.megavex.scoreboardlibrary.implementation.scheduler.RunningTask;
import net.megavex.scoreboardlibrary.implementation.scheduler.TaskScheduler;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class FoliaTaskScheduler
implements TaskScheduler {
    private static final Class<?> asyncSchedulerClass;
    private static final Class<?> scheduledTaskClass;
    private static final Class<?> cancelledStateClass;
    private static final MethodHandle getAsyncSchedulerMethod;
    private static final MethodHandle cancelScheduledTaskMethod;
    private static final MethodHandle runAtFixedRateMethod;
    private static final MethodHandle runDelayedMethod;
    private final Plugin plugin;
    private final Object asyncScheduler;

    public FoliaTaskScheduler(@NotNull Plugin plugin) {
        this.plugin = plugin;
        try {
            this.asyncScheduler = getAsyncSchedulerMethod.invoke(plugin.getServer());
        }
        catch (Throwable e) {
            throw new RuntimeException("couldn't get async scheduler", e);
        }
    }

    @Override
    @NotNull
    public RunningTask runEveryTick(@NotNull Runnable runnable) {
        Object scheduledTask;
        try {
            Consumer<Object> task = t -> runnable.run();
            scheduledTask = runAtFixedRateMethod.invoke(this.asyncScheduler, this.plugin, task, 50L, 50L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException("couldn't schedule repeating task", e);
        }
        return () -> {
            try {
                cancelScheduledTaskMethod.invoke(scheduledTask);
            }
            catch (Throwable e) {
                throw new RuntimeException("couldn't cancel scheduled task", e);
            }
        };
    }

    @Override
    public void runNextTick(@NotNull Runnable runnable) {
        Consumer<Object> task = t -> runnable.run();
        try {
            runDelayedMethod.invoke(this.asyncScheduler, this.plugin, task, 50L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException("couldn't schedule delayed task", e);
        }
    }

    static {
        try {
            asyncSchedulerClass = Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            scheduledTaskClass = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            cancelledStateClass = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask$CancelledState");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            getAsyncSchedulerMethod = lookup.findVirtual(Server.class, "getAsyncScheduler", MethodType.methodType(asyncSchedulerClass));
            cancelScheduledTaskMethod = lookup.findVirtual(scheduledTaskClass, "cancel", MethodType.methodType(cancelledStateClass));
            runAtFixedRateMethod = lookup.findVirtual(asyncSchedulerClass, "runAtFixedRate", MethodType.methodType(scheduledTaskClass, Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class));
            runDelayedMethod = lookup.findVirtual(asyncSchedulerClass, "runDelayed", MethodType.methodType(scheduledTaskClass, Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

