/*
 * Decompiled with CFR 0.152.
 */
package net.megavex.scoreboardlibrary.implementation.team;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.megavex.scoreboardlibrary.api.team.ScoreboardTeam;
import net.megavex.scoreboardlibrary.api.team.TeamDisplay;
import net.megavex.scoreboardlibrary.api.team.enums.CollisionRule;
import net.megavex.scoreboardlibrary.api.team.enums.NameTagVisibility;
import net.megavex.scoreboardlibrary.implementation.commons.CollectionProvider;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.EntriesPacketType;
import net.megavex.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import net.megavex.scoreboardlibrary.implementation.team.ScoreboardTeamImpl;
import net.megavex.scoreboardlibrary.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamDisplayImpl
implements TeamDisplay,
ImmutableTeamProperties<Component> {
    private final ScoreboardTeamImpl team;
    private final TeamDisplayPacketAdapter packetAdapter;
    private final Set<Player> players = CollectionProvider.set((int)4);
    private final List<String> entries = CollectionProvider.list((int)4);
    private final List<String> syncedEntries = CollectionProvider.list((int)4);
    private Component displayName = Component.empty();
    private Component prefix = Component.empty();
    private Component suffix = Component.empty();
    private boolean friendlyFire;
    private boolean canSeeFriendlyInvisibles;
    private NameTagVisibility nameTagVisibility = NameTagVisibility.ALWAYS;
    private CollisionRule collisionRule = CollisionRule.ALWAYS;
    private NamedTextColor playerColor = null;

    public TeamDisplayImpl(@NotNull ScoreboardTeamImpl team) {
        this.team = team;
        this.packetAdapter = team.packetAdapter().createTeamDisplayAdapter((ImmutableTeamProperties)this);
        this.packetAdapter.updateTeamPackets();
    }

    @NotNull
    public ScoreboardTeam team() {
        return this.team;
    }

    @NotNull
    public Collection<String> entries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @NotNull
    public Collection<String> syncedEntries() {
        return this.syncedEntries;
    }

    public boolean addEntry(@NotNull String entry) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
            this.team.teamManager().taskQueue().add(new TeamManagerTask.AddEntries(this, Collections.singleton(entry)));
            return true;
        }
        return false;
    }

    public boolean removeEntry(@NotNull String entry) {
        if (this.entries.remove(entry)) {
            this.team.teamManager().taskQueue().add(new TeamManagerTask.RemoveEntries(this, Collections.singleton(entry)));
            return true;
        }
        return false;
    }

    @NotNull
    public Component displayName() {
        return this.displayName;
    }

    @NotNull
    public TeamDisplay displayName(@NotNull ComponentLike displayName) {
        Preconditions.checkNotNull((Object)displayName);
        Component component = displayName.asComponent();
        if (!Objects.equals(this.displayName, component)) {
            this.displayName = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @NotNull
    public Component prefix() {
        return this.prefix;
    }

    @NotNull
    public TeamDisplay prefix(@NotNull ComponentLike prefix) {
        Preconditions.checkNotNull((Object)prefix);
        Component component = prefix.asComponent();
        if (!Objects.equals(this.prefix, component)) {
            this.prefix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @NotNull
    public Component suffix() {
        return this.suffix;
    }

    @NotNull
    public TeamDisplay suffix(@NotNull ComponentLike suffix) {
        Preconditions.checkNotNull((Object)suffix);
        Component component = suffix.asComponent();
        if (!Objects.equals(this.suffix, component)) {
            this.suffix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @NotNull
    public TeamDisplay friendlyFire(boolean friendlyFire) {
        if (this.friendlyFire != friendlyFire) {
            this.friendlyFire = friendlyFire;
            this.scheduleUpdate();
        }
        return this;
    }

    public boolean canSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @NotNull
    public TeamDisplay canSeeFriendlyInvisibles(boolean canSeeFriendlyInvisibles) {
        if (this.canSeeFriendlyInvisibles != canSeeFriendlyInvisibles) {
            this.canSeeFriendlyInvisibles = canSeeFriendlyInvisibles;
            this.scheduleUpdate();
        }
        return this;
    }

    @NotNull
    public NameTagVisibility nameTagVisibility() {
        return this.nameTagVisibility;
    }

    @NotNull
    public TeamDisplay nameTagVisibility(@NotNull NameTagVisibility nameTagVisibility) {
        Preconditions.checkNotNull((Object)nameTagVisibility);
        if (!Objects.equals(this.nameTagVisibility, nameTagVisibility)) {
            this.nameTagVisibility = nameTagVisibility;
            this.scheduleUpdate();
        }
        return this;
    }

    @NotNull
    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @NotNull
    public TeamDisplay collisionRule(@NotNull CollisionRule collisionRule) {
        Preconditions.checkNotNull((Object)collisionRule);
        if (!Objects.equals(this.collisionRule, collisionRule)) {
            this.collisionRule = collisionRule;
            this.scheduleUpdate();
        }
        return this;
    }

    @Nullable
    public NamedTextColor playerColor() {
        return this.playerColor;
    }

    @NotNull
    public TeamDisplay playerColor(@Nullable NamedTextColor playerColor) {
        if (!Objects.equals(this.playerColor, playerColor)) {
            this.playerColor = playerColor;
            this.scheduleUpdate();
        }
        return this;
    }

    @NotNull
    public TeamDisplayPacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Set<Player> players() {
        return this.players;
    }

    public void handleUpdateDisplay() {
        this.packetAdapter.updateTeamPackets();
        this.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, this.players());
    }

    public void handleAddEntries(@NotNull Collection<String> newEntries) {
        this.packetAdapter.sendEntries(EntriesPacketType.ADD, this.players(), newEntries);
        this.syncedEntries.addAll(newEntries);
        this.packetAdapter.updateTeamPackets();
    }

    public void handleRemoveEntries(@NotNull Collection<String> oldEntries) {
        this.packetAdapter.sendEntries(EntriesPacketType.REMOVE, this.players(), oldEntries);
        this.syncedEntries.removeAll(oldEntries);
        this.packetAdapter.updateTeamPackets();
    }

    private void scheduleUpdate() {
        Queue<TeamManagerTask> taskQueue = this.team.teamManager().taskQueue();
        TeamManagerTask lastTask = taskQueue.peek();
        if (lastTask instanceof TeamManagerTask.UpdateTeamDisplay && ((TeamManagerTask.UpdateTeamDisplay)lastTask).teamDisplay() == this) {
            return;
        }
        taskQueue.add(new TeamManagerTask.UpdateTeamDisplay(this));
    }
}

