/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import net.mguenther.kafka.junit.EmbeddedConnectConfig;
import net.mguenther.kafka.junit.EmbeddedKafkaConfig;
import net.mguenther.kafka.junit.EmbeddedZooKeeperConfig;

public class EmbeddedKafkaClusterConfig {
    private final EmbeddedZooKeeperConfig zooKeeperConfig;
    private final EmbeddedKafkaConfig kafkaConfig;
    private final EmbeddedConnectConfig connectConfig;

    public boolean usesConnect() {
        return this.connectConfig != null;
    }

    public static EmbeddedKafkaClusterConfigBuilder create() {
        return new EmbeddedKafkaClusterConfigBuilder();
    }

    public static EmbeddedKafkaClusterConfig useDefaults() {
        return EmbeddedKafkaClusterConfig.create().build();
    }

    public EmbeddedZooKeeperConfig getZooKeeperConfig() {
        return this.zooKeeperConfig;
    }

    public EmbeddedKafkaConfig getKafkaConfig() {
        return this.kafkaConfig;
    }

    public EmbeddedConnectConfig getConnectConfig() {
        return this.connectConfig;
    }

    public String toString() {
        return "EmbeddedKafkaClusterConfig(zooKeeperConfig=" + this.getZooKeeperConfig() + ", kafkaConfig=" + this.getKafkaConfig() + ", connectConfig=" + this.getConnectConfig() + ")";
    }

    public EmbeddedKafkaClusterConfig(EmbeddedZooKeeperConfig zooKeeperConfig, EmbeddedKafkaConfig kafkaConfig, EmbeddedConnectConfig connectConfig) {
        this.zooKeeperConfig = zooKeeperConfig;
        this.kafkaConfig = kafkaConfig;
        this.connectConfig = connectConfig;
    }

    public static class EmbeddedKafkaClusterConfigBuilder {
        private EmbeddedZooKeeperConfig zooKeeperConfig = EmbeddedZooKeeperConfig.useDefaults();
        private EmbeddedKafkaConfig kafkaConfig = EmbeddedKafkaConfig.useDefaults();
        private EmbeddedConnectConfig connectConfig = null;

        public EmbeddedKafkaClusterConfigBuilder provisionWith(EmbeddedZooKeeperConfig zooKeeperConfig) {
            this.zooKeeperConfig = zooKeeperConfig;
            return this;
        }

        public EmbeddedKafkaClusterConfigBuilder provisionWith(EmbeddedKafkaConfig kafkaConfig) {
            this.kafkaConfig = kafkaConfig;
            return this;
        }

        public EmbeddedKafkaClusterConfigBuilder provisionWith(EmbeddedConnectConfig connectConfig) {
            this.connectConfig = connectConfig;
            return this;
        }

        public EmbeddedKafkaClusterConfig build() {
            return new EmbeddedKafkaClusterConfig(this.zooKeeperConfig, this.kafkaConfig, this.connectConfig);
        }
    }
}

