/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.admin.AdminUtils;
import kafka.admin.RackAwareMode;
import kafka.api.LeaderAndIsr;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import net.mguenther.kafka.junit.TopicConfig;
import net.mguenther.kafka.junit.TopicManager;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class DefaultTopicManager
implements TopicManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultTopicManager.class);
    private final String zkConnectString;

    @Override
    public void createTopic(TopicConfig topicConfig) {
        try (ZkUtils zkUtils = null;){
            zkUtils = this.get();
            AdminUtils.createTopic((ZkUtils)zkUtils, (String)topicConfig.getTopic(), (int)topicConfig.getNumberOfPartitions(), (int)topicConfig.getNumberOfReplicas(), (Properties)topicConfig.getProperties(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$);
            log.info("Created topic '{}' with settings {}.", (Object)topicConfig.getTopic(), (Object)topicConfig);
        }
    }

    @Override
    public void deleteTopic(String topic) {
        try (ZkUtils zkUtils = null;){
            zkUtils = this.get();
            AdminUtils.deleteTopic((ZkUtils)zkUtils, (String)topic);
            log.info("Marked topic '{}' for deletion.", (Object)topic);
        }
    }

    @Override
    public boolean exists(String topic) {
        try (ZkUtils zkUtils = null;){
            zkUtils = this.get();
            boolean bl = AdminUtils.topicExists((ZkUtils)zkUtils, (String)topic);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, LeaderAndIsr> fetchLeaderAndIsr(String topic) {
        try (ZkUtils zkUtils = null;){
            zkUtils = this.get();
            HashMap<Integer, Object> leaderAndIsrForTopic = new HashMap<Integer, Object>();
            Option partitionsOpt = zkUtils.getTopicPartitionCount(topic);
            int partitions = partitionsOpt.isEmpty() ? 0 : (Integer)partitionsOpt.get();
            for (int partition = 0; partition < partitions; ++partition) {
                Option leaderAndIsrOption = zkUtils.getLeaderAndIsrForPartition(topic, partition);
                if (leaderAndIsrOption.isEmpty()) {
                    log.info("Unable to retrieve leader and ISR for topic-partition {}-{}.", (Object)topic, (Object)partition);
                    continue;
                }
                leaderAndIsrForTopic.put(partition, leaderAndIsrOption.get());
            }
            Map<Integer, LeaderAndIsr> map = Collections.unmodifiableMap(leaderAndIsrForTopic);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties fetchTopicConfig(String topic) {
        try (ZkUtils zkUtils = null;){
            zkUtils = this.get();
            Option topicConfigOpt = AdminUtils.fetchAllTopicConfigs((ZkUtils)zkUtils).get((Object)topic);
            if (topicConfigOpt.isEmpty()) {
                throw new RuntimeException(String.format("Unable to retrieve configuration for topic %s.", topic));
            }
            Properties properties = (Properties)topicConfigOpt.get();
            return properties;
        }
    }

    private ZkUtils get() {
        ZkClient zkClient = new ZkClient(this.zkConnectString, 10000, 8000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        ZkConnection zkConnection = new ZkConnection(this.zkConnectString);
        return new ZkUtils(zkClient, zkConnection, false);
    }

    public DefaultTopicManager(String zkConnectString) {
        this.zkConnectString = zkConnectString;
    }
}

