/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit.provider;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.api.LeaderAndIsr;
import net.mguenther.kafka.junit.TopicConfig;
import net.mguenther.kafka.junit.TopicManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpTopicManager
implements TopicManager {
    private static final Logger log = LoggerFactory.getLogger(NoOpTopicManager.class);

    @Override
    public void createTopic(TopicConfig config) {
        log.warn("No ZK Connection URL has been given. Discarding this request to create a new topic with parameters {}.", (Object)config);
    }

    @Override
    public void deleteTopic(String topic) {
        log.warn("No ZK Connection URL has been given. Discarding this request to delete topic {}.", (Object)topic);
    }

    @Override
    public boolean exists(String topic) {
        log.warn("No ZK Connection URL has been given. Discarding this request for topic existence of topic {}.", (Object)topic);
        return false;
    }

    @Override
    public Map<Integer, LeaderAndIsr> fetchLeaderAndIsr(String topic) {
        log.warn("No ZK Connection URL has been given. Discarding this request for broker assignments to topic-partitions for topic {}.", (Object)topic);
        return Collections.emptyMap();
    }

    @Override
    public Properties fetchTopicConfig(String topic) {
        log.warn("No ZK Connection URL has been given. Discarding this request and returning an empty instance of java.util.Properties.");
        return new Properties();
    }
}

