/*
 * Decompiled with CFR 0.152.
 */
package net.mguenther.kafka.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class EmbeddedConnectConfig {
    private final String workerId;
    private final Properties connectProperties;
    private final List<Properties> connectors;

    public static EmbeddedConnectConfigBuilder create() {
        return new EmbeddedConnectConfigBuilder();
    }

    public static EmbeddedConnectConfig useDefaults() {
        return EmbeddedConnectConfig.create().build();
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public Properties getConnectProperties() {
        return this.connectProperties;
    }

    public List<Properties> getConnectors() {
        return this.connectors;
    }

    public String toString() {
        return "EmbeddedConnectConfig(workerId=" + this.getWorkerId() + ", connectProperties=" + this.getConnectProperties() + ", connectors=" + this.getConnectors() + ")";
    }

    public EmbeddedConnectConfig(String workerId, Properties connectProperties, List<Properties> connectors) {
        this.workerId = workerId;
        this.connectProperties = connectProperties;
        this.connectors = connectors;
    }

    public static class EmbeddedConnectConfigBuilder {
        private final String workerId;
        private final Properties properties = new Properties();
        private final List<Properties> connectorProps = new ArrayList<Properties>();

        EmbeddedConnectConfigBuilder() {
            this(UUID.randomUUID().toString().substring(0, 7));
        }

        public <T> EmbeddedConnectConfigBuilder with(String propertyName, T value) {
            this.properties.put(propertyName, value);
            return this;
        }

        public EmbeddedConnectConfigBuilder withAll(Properties overrides) {
            this.properties.putAll((Map<?, ?>)overrides);
            return this;
        }

        private <T> void ifNonExisting(String propertyName, T value) {
            if (this.properties.get(propertyName) != null) {
                return;
            }
            this.properties.put(propertyName, value);
        }

        public EmbeddedConnectConfigBuilder deployConnector(Properties connectorProps) {
            this.connectorProps.add(connectorProps);
            return this;
        }

        public EmbeddedConnectConfigBuilder deployConnectors(Properties ... connectorProps) {
            this.connectorProps.addAll(Arrays.asList(connectorProps));
            return this;
        }

        public EmbeddedConnectConfig build() {
            this.ifNonExisting("key.converter", "org.apache.kafka.connect.storage.StringConverter");
            this.ifNonExisting("value.converter", "org.apache.kafka.connect.storage.StringConverter");
            this.ifNonExisting("internal.key.converter", "org.apache.kafka.connect.json.JsonConverter");
            this.ifNonExisting("internal.value.converter", "org.apache.kafka.connect.json.JsonConverter");
            this.ifNonExisting("connector.client.config.override.policy", "All");
            this.ifNonExisting("internal.key.converter.schemas.enable", "false");
            this.ifNonExisting("internal.value.converter.schemas.enable", "false");
            this.ifNonExisting("config.storage.replication.factor", "1");
            this.ifNonExisting("config.storage.topic", "embedded-connect-config");
            this.ifNonExisting("offset.storage.replication.factor", "1");
            this.ifNonExisting("offset.storage.topic", "embedded-connect-offsets");
            this.ifNonExisting("status.storage.replication.factor", "1");
            this.ifNonExisting("status.storage.topic", "embedded-connect-status");
            this.ifNonExisting("group.id", UUID.randomUUID().toString().substring(0, 7));
            return new EmbeddedConnectConfig(this.workerId, this.properties, this.connectorProps);
        }

        public EmbeddedConnectConfigBuilder(String workerId) {
            this.workerId = workerId;
        }
    }
}

